/*
 * Decompiled with CFR 0.152.
 */
package org.astarteplatform.devicesdk.protocol;

import java.lang.reflect.Type;
import org.astarteplatform.devicesdk.protocol.AstarteInvalidValueException;
import org.joda.time.DateTime;
import org.json.JSONException;
import org.json.JSONObject;

public class AstarteInterfaceMapping {
    private String path;
    private Type type;
    private Type primitiveArrayType;

    protected static AstarteInterfaceMapping fromJSON(JSONObject astarteMappingObject) throws JSONException {
        AstarteInterfaceMapping astarteInterfaceMapping = new AstarteInterfaceMapping();
        astarteInterfaceMapping.parseMappingFromJSON(astarteMappingObject);
        return astarteInterfaceMapping;
    }

    protected void parseMappingFromJSON(JSONObject astarteMappingObject) throws JSONException {
        this.path = astarteMappingObject.getString("endpoint");
        this.type = AstarteInterfaceMapping.stringToJavaType(astarteMappingObject.getString("type"));
        this.primitiveArrayType = AstarteInterfaceMapping.stringToPrimitiveArrayJavaType(astarteMappingObject.getString("type"));
    }

    public String getPath() {
        return this.path;
    }

    public Type getType() {
        return this.type;
    }

    protected boolean isTypeCompatible(Type otherType) {
        return otherType == this.type || otherType == this.primitiveArrayType;
    }

    public void validatePayload(Object payload) throws AstarteInvalidValueException {
        if (!this.isTypeCompatible(payload.getClass())) {
            throw new AstarteInvalidValueException(String.format("Value incompatible with parameter type for %s: %s expected, %s found", this.getPath(), this.getType(), payload.getClass()));
        }
        if (payload instanceof Double && !AstarteInterfaceMapping.isFinite((Double)payload)) {
            throw new AstarteInvalidValueException(String.format("Value per %s cannot be NaN", this.getPath()));
        }
        if (payload instanceof Double[]) {
            Double[] arrayPayload;
            for (Double value : arrayPayload = (Double[])payload) {
                if (AstarteInterfaceMapping.isFinite(value)) continue;
                throw new AstarteInvalidValueException(String.format("Value per %s cannot be NaN", this.getPath()));
            }
        }
    }

    private static boolean isFinite(Double value) {
        return !value.isInfinite() && !value.isNaN();
    }

    public void validatePayload(Object payload, DateTime timestamp) throws AstarteInvalidValueException {
        this.validatePayload(payload);
    }

    private static Type stringToJavaType(String typeString) {
        switch (typeString) {
            case "string": {
                return String.class;
            }
            case "integer": {
                return Integer.class;
            }
            case "double": {
                return Double.class;
            }
            case "longinteger": {
                return Long.class;
            }
            case "boolean": {
                return Boolean.class;
            }
            case "binaryblob": {
                return Byte[].class;
            }
            case "datetime": {
                return DateTime.class;
            }
            case "stringarray": {
                return String[].class;
            }
            case "integerarray": {
                return Integer[].class;
            }
            case "doublearray": {
                return Double[].class;
            }
            case "longintegerarray": {
                return Long[].class;
            }
            case "booleanarray": {
                return Boolean[].class;
            }
            case "binaryblobarray": {
                return Byte[][].class;
            }
            case "datetimearray": {
                return DateTime[].class;
            }
        }
        return Object.class;
    }

    private static Type stringToPrimitiveArrayJavaType(String typeString) {
        switch (typeString) {
            case "binaryblob": {
                return byte[].class;
            }
            case "integerarray": {
                return int[].class;
            }
            case "doublearray": {
                return double[].class;
            }
            case "longintegerarray": {
                return long[].class;
            }
            case "booleanarray": {
                return boolean[].class;
            }
            case "binaryblobarray": {
                return byte[][].class;
            }
        }
        return null;
    }
}

