/*
 * Decompiled with CFR 0.152.
 */
package org.astarteplatform.devicesdk.protocol;

import java.util.Map;
import org.astarteplatform.devicesdk.AstartePropertyStorage;
import org.astarteplatform.devicesdk.AstartePropertyStorageException;
import org.astarteplatform.devicesdk.protocol.AstarteInterface;
import org.joda.time.DateTime;

public abstract class AstartePropertyInterface
extends AstarteInterface {
    final AstartePropertyStorage mPropertyStorage;

    AstartePropertyInterface(AstartePropertyStorage propertyStorage) {
        this.mPropertyStorage = propertyStorage;
    }

    public Map<String, Object> getAllValues() {
        if (this.mPropertyStorage == null) {
            return null;
        }
        try {
            return this.mPropertyStorage.getStoredValuesForInterface(this);
        }
        catch (AstartePropertyStorageException e) {
            return null;
        }
    }

    private <T> T getPropertyValue(String path, Class<T> clazz) {
        if (this.mPropertyStorage == null) {
            return null;
        }
        Map<String, Object> storedPaths = null;
        try {
            storedPaths = this.mPropertyStorage.getStoredValuesForInterface(this);
        }
        catch (AstartePropertyStorageException e) {
            return null;
        }
        if (!storedPaths.containsKey(path)) {
            return null;
        }
        Object value = storedPaths.get(path);
        if (value == null) {
            return null;
        }
        return clazz.cast(value);
    }

    public String getPropertyValueString(String path) {
        return this.getPropertyValue(path, String.class);
    }

    public Boolean getPropertyValueBoolean(String path) {
        return this.getPropertyValue(path, Boolean.class);
    }

    public Integer getPropertyValueInt(String path) {
        return this.getPropertyValue(path, Integer.class);
    }

    public Long getPropertyValueLong(String path) {
        return this.getPropertyValue(path, Long.class);
    }

    public Double getPropertyValueDouble(String path) {
        return this.getPropertyValue(path, Double.class);
    }

    public byte[] getPropertyValueByteArray(String path) {
        return this.getPropertyValue(path, byte[].class);
    }

    public DateTime getPropertyValueDateTime(String path) {
        return this.getPropertyValue(path, DateTime.class);
    }
}

