/*
 * Decompiled with CFR 0.152.
 */
package org.astarteplatform.devicesdk.protocol;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.astarteplatform.devicesdk.protocol.AstarteAggregateDatastreamEvent;
import org.astarteplatform.devicesdk.protocol.AstarteAggregateDatastreamEventListener;
import org.astarteplatform.devicesdk.protocol.AstarteAggregateDatastreamInterface;
import org.astarteplatform.devicesdk.protocol.AstarteInterface;
import org.astarteplatform.devicesdk.protocol.AstarteInterfaceMapping;
import org.astarteplatform.devicesdk.protocol.AstarteServerValue;
import org.astarteplatform.devicesdk.protocol.AstarteServerValueBuilder;
import org.astarteplatform.devicesdk.protocol.AstarteServerValuePublisher;
import org.bson.BSONObject;
import org.joda.time.DateTime;

public class AstarteServerAggregateDatastreamInterface
extends AstarteAggregateDatastreamInterface
implements AstarteServerValueBuilder,
AstarteServerValuePublisher {
    private final Collection<AstarteAggregateDatastreamEventListener> mListeners = new HashSet<AstarteAggregateDatastreamEventListener>();

    AstarteServerAggregateDatastreamInterface() {
    }

    public void addListener(AstarteAggregateDatastreamEventListener listener) {
        this.mListeners.add(listener);
    }

    public void removeListener(AstarteAggregateDatastreamEventListener listener) {
        this.mListeners.remove(listener);
    }

    public Collection<AstarteAggregateDatastreamEventListener> getAllListeners() {
        return this.mListeners;
    }

    @Override
    public AstarteServerValue build(String interfacePath, Object serverValue, DateTime timestamp) {
        if (serverValue == null) {
            return null;
        }
        BSONObject astartePayload = (BSONObject)serverValue;
        HashMap<String, Object> astarteAggregate = new HashMap<String, Object>();
        for (String key : astartePayload.keySet()) {
            for (Map.Entry<String, AstarteInterfaceMapping> m : this.getMappings().entrySet()) {
                if (!AstarteInterface.isPathCompatibleWithMapping(interfacePath + "/" + key, m.getValue().getPath())) continue;
                if (m.getValue().getType() == DateTime.class) {
                    astarteAggregate.put(key, new DateTime(astartePayload.get(key)));
                    continue;
                }
                astarteAggregate.put(key, astartePayload.get(key));
            }
        }
        return new AstarteServerValue.AstarteServerValueBuilder(astarteAggregate).interfacePath(interfacePath).build();
    }

    @Override
    public void publish(AstarteServerValue payload) {
        AstarteAggregateDatastreamEvent e = new AstarteAggregateDatastreamEvent(this.getInterfaceName(), payload.getMapValue(), payload.getTimestamp());
        for (AstarteAggregateDatastreamEventListener listener : this.mListeners) {
            listener.valueReceived(e);
        }
    }
}

