/*
 * Decompiled with CFR 0.152.
 */
package org.astarteplatform.devicesdk.protocol;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.astarteplatform.devicesdk.protocol.AstarteDatastreamEvent;
import org.astarteplatform.devicesdk.protocol.AstarteDatastreamEventListener;
import org.astarteplatform.devicesdk.protocol.AstarteDatastreamInterface;
import org.astarteplatform.devicesdk.protocol.AstarteInterface;
import org.astarteplatform.devicesdk.protocol.AstarteInterfaceMapping;
import org.astarteplatform.devicesdk.protocol.AstarteServerValue;
import org.astarteplatform.devicesdk.protocol.AstarteServerValueBuilder;
import org.astarteplatform.devicesdk.protocol.AstarteServerValuePublisher;
import org.joda.time.DateTime;

public class AstarteServerDatastreamInterface
extends AstarteDatastreamInterface
implements AstarteServerValueBuilder,
AstarteServerValuePublisher {
    private final Collection<AstarteDatastreamEventListener> mListeners = new HashSet<AstarteDatastreamEventListener>();

    AstarteServerDatastreamInterface() {
    }

    public void addListener(AstarteDatastreamEventListener listener) {
        this.mListeners.add(listener);
    }

    public void removeListener(AstarteDatastreamEventListener listener) {
        this.mListeners.remove(listener);
    }

    public Collection<AstarteDatastreamEventListener> getAllListeners() {
        return this.mListeners;
    }

    @Override
    public AstarteServerValue build(String interfacePath, Object serverValue, DateTime timestamp) {
        AstarteServerValue astarteServerValue;
        AstarteInterfaceMapping targetMapping = null;
        for (Map.Entry<String, AstarteInterfaceMapping> entry : this.getMappings().entrySet()) {
            if (!AstarteInterface.isPathCompatibleWithMapping(interfacePath, entry.getKey())) continue;
            targetMapping = entry.getValue();
            break;
        }
        if (targetMapping != null) {
            Object astarteValue = serverValue;
            if (targetMapping.getType() == DateTime.class) {
                astarteValue = new DateTime(serverValue);
            }
            astarteServerValue = new AstarteServerValue.AstarteServerValueBuilder(astarteValue).interfacePath(interfacePath).timestamp(timestamp).build();
        } else {
            System.err.printf("Got an unexpected path %s for interface %s!%n", interfacePath, this.getInterfaceName());
            astarteServerValue = null;
        }
        return astarteServerValue;
    }

    @Override
    public void publish(AstarteServerValue payload) {
        AstarteDatastreamEvent e = new AstarteDatastreamEvent(this.getInterfaceName(), payload.getInterfacePath(), payload.getValue(), payload.getTimestamp());
        for (AstarteDatastreamEventListener listener : this.mListeners) {
            listener.valueReceived(e);
        }
    }
}

