/*
 * Decompiled with CFR 0.152.
 */
package org.astarteplatform.devicesdk.protocol;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.astarteplatform.devicesdk.AstartePropertyStorage;
import org.astarteplatform.devicesdk.protocol.AstarteInterface;
import org.astarteplatform.devicesdk.protocol.AstarteInterfaceMapping;
import org.astarteplatform.devicesdk.protocol.AstartePropertyEvent;
import org.astarteplatform.devicesdk.protocol.AstartePropertyEventListener;
import org.astarteplatform.devicesdk.protocol.AstartePropertyInterface;
import org.astarteplatform.devicesdk.protocol.AstarteServerValue;
import org.astarteplatform.devicesdk.protocol.AstarteServerValueBuilder;
import org.astarteplatform.devicesdk.protocol.AstarteServerValuePublisher;
import org.joda.time.DateTime;

public class AstarteServerPropertyInterface
extends AstartePropertyInterface
implements AstarteServerValueBuilder,
AstarteServerValuePublisher {
    private final Collection<AstartePropertyEventListener> mListeners = new HashSet<AstartePropertyEventListener>();

    AstarteServerPropertyInterface(AstartePropertyStorage propertyStorage) {
        super(propertyStorage);
    }

    public void addListener(AstartePropertyEventListener listener) {
        this.mListeners.add(listener);
    }

    public void removeListener(AstartePropertyEventListener listener) {
        this.mListeners.remove(listener);
    }

    public Collection<AstartePropertyEventListener> getAllListeners() {
        return this.mListeners;
    }

    @Override
    public AstarteServerValue build(String interfacePath, Object serverValue, DateTime timestamp) {
        AstarteServerValue astarteServerValue;
        AstarteInterfaceMapping targetMapping = null;
        for (Map.Entry<String, AstarteInterfaceMapping> entry : this.getMappings().entrySet()) {
            if (!AstarteInterface.isPathCompatibleWithMapping(interfacePath, entry.getKey())) continue;
            targetMapping = entry.getValue();
            break;
        }
        if (targetMapping != null) {
            Object astarteValue = serverValue;
            if (targetMapping.getType() == DateTime.class) {
                astarteValue = new DateTime(serverValue);
            }
            astarteServerValue = new AstarteServerValue.AstarteServerValueBuilder(astarteValue).interfacePath(interfacePath).build();
        } else {
            System.err.printf("Got an unexpected path %s for interface %s!%n", interfacePath, this.getInterfaceName());
            astarteServerValue = null;
        }
        return astarteServerValue;
    }

    @Override
    public void publish(AstarteServerValue payload) {
        AstartePropertyEvent e = new AstartePropertyEvent(this.getInterfaceName(), payload.getInterfacePath(), payload.getValue());
        if (payload.getValue() == null) {
            for (AstartePropertyEventListener listener : this.mListeners) {
                listener.propertyUnset(e);
            }
        } else {
            for (AstartePropertyEventListener listener : this.mListeners) {
                listener.propertyReceived(e);
            }
        }
    }
}

