/*
 * Decompiled with CFR 0.152.
 */
package org.astarteplatform.devicesdk.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.astarteplatform.devicesdk.util.DecodedMessage;
import org.bson.BSONCallback;
import org.bson.BSONDecoder;
import org.bson.BSONObject;
import org.bson.BasicBSONEncoder;
import org.bson.BasicBSONObject;
import org.bson.types.BasicBSONList;
import org.joda.time.DateTime;

public class AstartePayload {
    public static byte[] serialize(Object o, Date t) {
        if (o == null) {
            return new byte[0];
        }
        o = AstartePayload.prepareDateTimeValues(o);
        BasicBSONObject bsonObject = new BasicBSONObject();
        bsonObject.append("v", o);
        if (t != null) {
            bsonObject.append("t", (Object)t);
        }
        return new BasicBSONEncoder().encode((BSONObject)bsonObject);
    }

    public static DecodedMessage deserialize(byte[] mqttPayload, BSONDecoder mBSONDecoder, BSONCallback mBSONCallback) {
        DecodedMessage decoded = new DecodedMessage();
        mBSONCallback.reset();
        mBSONDecoder.decode(mqttPayload, mBSONCallback);
        BSONObject astartePayload = (BSONObject)mBSONCallback.get();
        Object decodedObject = astartePayload.get("v");
        if (decodedObject instanceof Date) {
            decoded.setPayload(new DateTime(decodedObject));
        } else if (decodedObject instanceof BasicBSONList) {
            BasicBSONList list = (BasicBSONList)decodedObject;
            Object[] valueArray = AstartePayload.bsonListToArray(list);
            if (valueArray instanceof Date[]) {
                decoded.setPayload(AstartePayload.dateArrayToDateTimeArray((Date[])valueArray));
            } else {
                decoded.setPayload(valueArray);
            }
        } else {
            if (decodedObject instanceof BasicBSONObject) {
                BasicBSONObject map = (BasicBSONObject)decodedObject;
                for (String key : map.keySet()) {
                    Object value = map.get(key);
                    if (value instanceof Date) {
                        map.put(key, new DateTime(value));
                        continue;
                    }
                    if (!(value instanceof BasicBSONList)) continue;
                    Object[] valueArray = AstartePayload.bsonListToArray((BasicBSONList)value);
                    if (valueArray instanceof Date[]) {
                        map.put(key, AstartePayload.dateArrayToDateTimeArray((Date[])valueArray));
                        continue;
                    }
                    map.put(key, valueArray);
                }
            }
            decoded.setPayload(decodedObject);
        }
        if (astartePayload.containsField("t")) {
            decoded.setTimestamp(new DateTime(astartePayload.get("t")));
        }
        return decoded;
    }

    private static Object[] bsonListToArray(BasicBSONList list) {
        if (!list.containsField("0")) {
            return new Object[0];
        }
        Class<?> clazz = list.get("0").getClass();
        int size = list.keySet().size();
        Object[] test = (Object[])Array.newInstance(clazz, size);
        System.arraycopy(list.toArray(), 0, test, 0, size);
        return test;
    }

    private static Object prepareDateTimeValues(Object o) {
        if (o instanceof DateTime) {
            return ((DateTime)o).toDate();
        }
        if (o instanceof DateTime[]) {
            return AstartePayload.dateTimesArrayToDateList((DateTime[])o);
        }
        if (o instanceof Map) {
            HashMap aggregate = new HashMap((Map)o);
            for (Map.Entry entry : aggregate.entrySet()) {
                if (entry.getValue() instanceof DateTime) {
                    entry.setValue(((DateTime)entry.getValue()).toDate());
                    continue;
                }
                if (!(entry.getValue() instanceof DateTime[])) continue;
                entry.setValue(AstartePayload.dateTimesArrayToDateList((DateTime[])entry.getValue()));
            }
            return aggregate;
        }
        return o;
    }

    private static List<Date> dateTimesArrayToDateList(DateTime[] in) {
        ArrayList<Date> out = new ArrayList<Date>();
        for (DateTime d : in) {
            out.add(d.toDate());
        }
        return out;
    }

    private static DateTime[] dateArrayToDateTimeArray(Date[] in) {
        DateTime[] out = new DateTime[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = new DateTime((Object)in[i]);
        }
        return out;
    }
}

