/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.cache;

import java.time.Duration;
import javax.annotation.ParametersAreNonnullByDefault;
import org.assertj.core.api.Assertions;
import org.atlanmod.commons.AbstractTest;
import org.atlanmod.commons.cache.CacheStats;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@ParametersAreNonnullByDefault
public class CacheStatsTest
extends AbstractTest {
    private CacheStats stats;

    @BeforeEach
    public void setUp() {
        this.stats = new CacheStats(30L, 10L, 15L, 5L, 2000L, 2L);
    }

    @Test
    public void testConstructor() {
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> new CacheStats(0L, 0L, 0L, 0L, 0L, 0L))).isNull();
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> new CacheStats(-1L, 0L, 0L, 0L, 0L, 0L))).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> new CacheStats(0L, -1L, 0L, 0L, 0L, 0L))).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> new CacheStats(0L, 0L, -1L, 0L, 0L, 0L))).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> new CacheStats(0L, 0L, 0L, -1L, 0L, 0L))).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> new CacheStats(0L, 0L, 0L, 0L, -1L, 0L))).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> new CacheStats(0L, 0L, 0L, 0L, 0L, -1L))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testRequestCount() {
        Assertions.assertThat((long)this.stats.requestCount()).isEqualTo(40L);
    }

    @Test
    public void testHitCount() {
        Assertions.assertThat((long)this.stats.hitCount()).isEqualTo(30L);
    }

    @Test
    public void testHitRate() {
        Assertions.assertThat((double)this.stats.hitRate()).isEqualTo(0.75);
    }

    @Test
    public void testMissCount() {
        Assertions.assertThat((long)this.stats.missCount()).isEqualTo(10L);
    }

    @Test
    public void testMissRate() {
        Assertions.assertThat((double)this.stats.missRate()).isEqualTo(0.25);
    }

    @Test
    public void testLoadCount() {
        Assertions.assertThat((long)this.stats.loadCount()).isEqualTo(20L);
    }

    @Test
    public void testLoadSuccessCount() {
        Assertions.assertThat((long)this.stats.loadSuccessCount()).isEqualTo(15L);
    }

    @Test
    public void testLoadFailureCount() {
        Assertions.assertThat((long)this.stats.loadFailureCount()).isEqualTo(5L);
    }

    @Test
    public void testLoadFailureRate() {
        Assertions.assertThat((double)this.stats.loadFailureRate()).isEqualTo(0.25);
    }

    @Test
    public void testTotalLoadTime() {
        Assertions.assertThat((Comparable)this.stats.totalLoadTime()).isEqualByComparingTo((Comparable)Duration.ofNanos(2000L));
    }

    @Test
    public void testAverageLoadPenalty() {
        Assertions.assertThat((double)this.stats.averageLoadPenalty()).isEqualTo(100.0);
    }

    @Test
    public void testEvictionCount() {
        Assertions.assertThat((long)this.stats.evictionCount()).isEqualTo(2L);
    }

    @Test
    public void testMinus() {
        CacheStats result = this.stats.minus(this.stats);
        Assertions.assertThat((boolean)this.stats.equals((Object)result)).isFalse();
        Assertions.assertThat((int)this.stats.hashCode()).isNotEqualTo(result.hashCode());
        Assertions.assertThat((long)result.requestCount()).isEqualTo(0L);
        Assertions.assertThat((long)result.hitCount()).isEqualTo(0L);
        Assertions.assertThat((double)result.hitRate()).isEqualTo(1.0);
        Assertions.assertThat((long)result.missCount()).isEqualTo(0L);
        Assertions.assertThat((double)result.missRate()).isEqualTo(0.0);
        Assertions.assertThat((long)result.loadCount()).isEqualTo(0L);
        Assertions.assertThat((long)result.loadSuccessCount()).isEqualTo(0L);
        Assertions.assertThat((long)result.loadFailureCount()).isEqualTo(0L);
        Assertions.assertThat((double)result.loadFailureRate()).isEqualTo(0.0);
        Assertions.assertThat((Comparable)result.totalLoadTime()).isEqualByComparingTo((Comparable)Duration.ofNanos(0L));
        Assertions.assertThat((double)result.averageLoadPenalty()).isEqualTo(0.0);
        Assertions.assertThat((long)result.evictionCount()).isEqualTo(0L);
    }

    @Test
    public void testPlus() {
        CacheStats result = this.stats.plus(this.stats);
        Assertions.assertThat((boolean)this.stats.equals((Object)result)).isFalse();
        Assertions.assertThat((int)this.stats.hashCode()).isNotEqualTo(result.hashCode());
        Assertions.assertThat((long)result.requestCount()).isEqualTo(80L);
        Assertions.assertThat((long)result.hitCount()).isEqualTo(60L);
        Assertions.assertThat((double)result.hitRate()).isEqualTo(0.75);
        Assertions.assertThat((long)result.missCount()).isEqualTo(20L);
        Assertions.assertThat((double)result.missRate()).isEqualTo(0.25);
        Assertions.assertThat((long)result.loadCount()).isEqualTo(40L);
        Assertions.assertThat((long)result.loadSuccessCount()).isEqualTo(30L);
        Assertions.assertThat((long)result.loadFailureCount()).isEqualTo(10L);
        Assertions.assertThat((double)result.loadFailureRate()).isEqualTo(0.25);
        Assertions.assertThat((Comparable)result.totalLoadTime()).isEqualByComparingTo((Comparable)Duration.ofNanos(4000L));
        Assertions.assertThat((double)result.averageLoadPenalty()).isEqualTo(100.0);
        Assertions.assertThat((long)result.evictionCount()).isEqualTo(4L);
    }

    @Test
    public void testEquals() {
        Assertions.assertThat((boolean)this.stats.equals((Object)this.stats)).isTrue();
        Assertions.assertThat((boolean)this.stats.equals(null)).isFalse();
        Assertions.assertThat((boolean)this.stats.equals((Object)new CacheStats(0L, 10L, 15L, 5L, 2000L, 2L))).isFalse();
        Assertions.assertThat((boolean)this.stats.equals((Object)new CacheStats(30L, 0L, 15L, 5L, 2000L, 2L))).isFalse();
        Assertions.assertThat((boolean)this.stats.equals((Object)new CacheStats(30L, 10L, 0L, 5L, 2000L, 2L))).isFalse();
        Assertions.assertThat((boolean)this.stats.equals((Object)new CacheStats(30L, 10L, 15L, 0L, 2000L, 2L))).isFalse();
        Assertions.assertThat((boolean)this.stats.equals((Object)new CacheStats(30L, 10L, 15L, 5L, 0L, 2L))).isFalse();
        Assertions.assertThat((boolean)this.stats.equals((Object)new CacheStats(30L, 10L, 15L, 5L, 2000L, 0L))).isFalse();
    }
}

