/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.collect;

import javax.annotation.ParametersAreNonnullByDefault;
import org.assertj.core.api.Assertions;
import org.atlanmod.commons.AbstractTest;
import org.atlanmod.commons.collect.Range;
import org.junit.jupiter.api.Test;

@ParametersAreNonnullByDefault
public class RangeTest
extends AbstractTest {
    @Test
    public void testOpen() {
        Range r0 = Range.open((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(2));
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(-1))).isFalse();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(0))).isFalse();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(1))).isTrue();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(2))).isFalse();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(3))).isFalse();
    }

    @Test
    public void testClosed() {
        Range r0 = Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(2));
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(-1))).isFalse();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(0))).isTrue();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(1))).isTrue();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(2))).isTrue();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(3))).isFalse();
    }

    @Test
    public void testOpenClosed() {
        Range r0 = Range.openClosed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(2));
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(-1))).isFalse();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(0))).isFalse();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(1))).isTrue();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(2))).isTrue();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(3))).isFalse();
    }

    @Test
    public void testClosedOpen() {
        Range r0 = Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(2));
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(-1))).isFalse();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(0))).isTrue();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(1))).isTrue();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(2))).isFalse();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(3))).isFalse();
    }

    @Test
    public void testSingleton() {
        Range r0 = Range.singleton((Comparable)Integer.valueOf(1));
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(-1))).isFalse();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(0))).isFalse();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(1))).isTrue();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(2))).isFalse();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(3))).isFalse();
    }

    @Test
    public void testAtLeast() {
        Range r0 = Range.atLeast((Comparable)Integer.valueOf(1));
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(-1))).isFalse();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(0))).isFalse();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(1))).isTrue();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(2))).isTrue();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(3))).isTrue();
    }

    @Test
    public void testAtMost() {
        Range r0 = Range.atMost((Comparable)Integer.valueOf(1));
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(-1))).isTrue();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(0))).isTrue();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(1))).isTrue();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(2))).isFalse();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(3))).isFalse();
    }

    @Test
    public void testGreaterThan() {
        Range r0 = Range.greaterThan((Comparable)Integer.valueOf(1));
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(-1))).isFalse();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(0))).isFalse();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(1))).isFalse();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(2))).isTrue();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(3))).isTrue();
    }

    @Test
    public void testLessThan() {
        Range r0 = Range.lessThan((Comparable)Integer.valueOf(1));
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(-1))).isTrue();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(0))).isTrue();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(1))).isFalse();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(2))).isFalse();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(3))).isFalse();
    }

    @Test
    public void testAll() {
        Range r0 = Range.all();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(-1))).isTrue();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(0))).isTrue();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(1))).isTrue();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(2))).isTrue();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(3))).isTrue();
    }

    @Test
    public void testEmpty() {
        Range r0 = Range.empty();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(-1))).isFalse();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(0))).isFalse();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(1))).isFalse();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(2))).isFalse();
        Assertions.assertThat((boolean)r0.contains((Comparable)Integer.valueOf(3))).isFalse();
    }

    @Test
    public void testAnd() {
        Range r0 = Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(2));
        Range r1 = Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3));
        Range r01 = Range.and((Range)r0, (Range)r1);
        Assertions.assertThat((boolean)r01.contains((Comparable)Integer.valueOf(0))).isFalse();
        Assertions.assertThat((boolean)r01.contains((Comparable)Integer.valueOf(1))).isTrue();
        Assertions.assertThat((boolean)r01.contains((Comparable)Integer.valueOf(2))).isTrue();
        Assertions.assertThat((boolean)r01.contains((Comparable)Integer.valueOf(3))).isFalse();
    }

    @Test
    public void testOr() {
        Range r0 = Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(2));
        Range r1 = Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3));
        Range r01 = Range.or((Range)r0, (Range)r1);
        Assertions.assertThat((boolean)r01.contains((Comparable)Integer.valueOf(0))).isTrue();
        Assertions.assertThat((boolean)r01.contains((Comparable)Integer.valueOf(1))).isTrue();
        Assertions.assertThat((boolean)r01.contains((Comparable)Integer.valueOf(2))).isTrue();
        Assertions.assertThat((boolean)r01.contains((Comparable)Integer.valueOf(3))).isTrue();
    }

    @Test
    public void testXor() {
        Range r0 = Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(2));
        Range r1 = Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3));
        Range r01 = Range.xor((Range)r0, (Range)r1);
        Assertions.assertThat((boolean)r01.contains((Comparable)Integer.valueOf(0))).isTrue();
        Assertions.assertThat((boolean)r01.contains((Comparable)Integer.valueOf(1))).isFalse();
        Assertions.assertThat((boolean)r01.contains((Comparable)Integer.valueOf(2))).isFalse();
        Assertions.assertThat((boolean)r01.contains((Comparable)Integer.valueOf(3))).isTrue();
    }
}

