/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.extension;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class MemoryUsage {
    @Nonnegative
    private final long total;
    @Nonnegative
    private final long free;

    private MemoryUsage(Runtime runtime) {
        this.total = runtime.totalMemory();
        this.free = runtime.freeMemory();
    }

    @Nonnull
    public static MemoryUsage now() {
        return new MemoryUsage(Runtime.getRuntime());
    }

    private static long convertUnit(long bytes) {
        return bytes / 1024L / 1024L;
    }

    @Nonnegative
    public long total() {
        return this.total;
    }

    @Nonnegative
    public long free() {
        return this.free;
    }

    @Nonnegative
    public long used() {
        return this.total() - this.free();
    }

    @ParametersAreNonnullByDefault
    public static final class Diff {
        @Nonnull
        private final MemoryUsage start;
        @Nonnull
        private final MemoryUsage end;

        private Diff(MemoryUsage start, MemoryUsage end) {
            this.start = start;
            this.end = end;
        }

        @Nonnull
        public static Diff between(MemoryUsage start, MemoryUsage end) {
            return new Diff(start, end);
        }

        public long total() {
            return this.end.total() - this.start.total();
        }

        public long free() {
            return this.end.free() - this.start.free();
        }

        public long used() {
            return this.end.used() - this.start.used();
        }

        public String toString() {
            long usedDiff = MemoryUsage.convertUnit(this.used());
            long totalDiff = MemoryUsage.convertUnit(this.total());
            return String.format("%s / %s%s MB", usedDiff < 0L ? "<0" : Long.valueOf(usedDiff), MemoryUsage.convertUnit(this.end.total()), totalDiff == 0L ? "" : "(" + (totalDiff > 0L ? "+" + totalDiff : Long.valueOf(totalDiff)) + ")");
        }
    }
}

