/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.extension;

import java.util.Objects;
import java.util.OptionalLong;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Preconditions;
import org.atlanmod.commons.Timeout;
import org.atlanmod.commons.log.Log;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

@ParametersAreNonnullByDefault
public final class TimeoutExtension
implements BeforeEachCallback,
AfterEachCallback {
    @Nullable
    private Timer timer;

    public void beforeEach(ExtensionContext context) throws Exception {
        this.getTimeout(context).ifPresent(timeout -> {
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    String msg = String.format("timeout exceeded: %d ms", timeout);
                    Log.error((CharSequence)msg);
                }
            }, timeout);
        });
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (Objects.nonNull(this.timer)) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    @Nonnull
    @Nonnegative
    private OptionalLong getTimeout(ExtensionContext context) {
        Timeout annotation = null;
        if (context.getRequiredTestMethod().isAnnotationPresent(Timeout.class)) {
            annotation = context.getRequiredTestMethod().getAnnotation(Timeout.class);
        } else if (context.getRequiredTestClass().isAnnotationPresent(Timeout.class)) {
            annotation = context.getRequiredTestClass().getAnnotation(Timeout.class);
        }
        if (Objects.nonNull(annotation)) {
            long timeout = annotation.timeout();
            TimeUnit unit = annotation.unit();
            Preconditions.checkGreaterThanOrEqualTo((Comparable)Long.valueOf(timeout), (Comparable)Long.valueOf(0L), (String)"timeout (%d) must not be negative", (Object[])new Object[]{timeout});
            return OptionalLong.of(unit.toMillis(timeout));
        }
        return OptionalLong.empty();
    }
}

