/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.AbstractTest;
import org.atlanmod.commons.concurrent.MoreThreads;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;

@ParametersAreNonnullByDefault
public abstract class AbstractFileBasedTest
extends AbstractTest {
    private static Path tempFolder;
    private Path currentTempFile;

    private static void deleteDirectory(Path directory) {
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.deleteIfExists(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.deleteIfExists(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
            Files.deleteIfExists(directory);
        }
        catch (Exception e) {
            try {
                MoreThreads.executeAtExit(() -> AbstractFileBasedTest.deleteDirectory(directory));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Nonnull
    private static Path createTempFolder() throws IOException {
        if (Objects.isNull(tempFolder)) {
            tempFolder = Files.createTempDirectory("atlanmod", new FileAttribute[0]);
        }
        return tempFolder;
    }

    @AfterAll
    static void cleanTempFolder() throws Exception {
        if (Objects.nonNull(tempFolder) && Files.exists(tempFolder, new LinkOption[0])) {
            AbstractFileBasedTest.deleteDirectory(tempFolder);
        }
        tempFolder = null;
    }

    @Nonnull
    private Path createTempFile() throws IOException {
        if (Objects.isNull(this.currentTempFile)) {
            Path createdFolder = Files.createTempDirectory(AbstractFileBasedTest.createTempFolder(), "test", new FileAttribute[0]);
            Files.deleteIfExists(createdFolder);
            this.currentTempFile = createdFolder;
        }
        return this.currentTempFile;
    }

    @AfterEach
    void cleanTempFile() throws Exception {
        this.currentTempFile = null;
    }

    @Nonnull
    protected File currentTempFile() throws IOException {
        return this.createTempFile().toFile();
    }
}

