/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.io;

import javax.annotation.ParametersAreNonnullByDefault;
import org.assertj.core.api.Assertions;
import org.atlanmod.commons.AbstractTest;
import org.atlanmod.commons.io.MoreFiles;
import org.junit.jupiter.api.Test;

@ParametersAreNonnullByDefault
public class MoreFilesTest
extends AbstractTest {
    @Test
    public void testFileExtension() {
        Assertions.assertThat((String)MoreFiles.fileExtension((String)".log")).isEqualTo((Object)"log");
        Assertions.assertThat((String)MoreFiles.fileExtension((String)"atlanmod.log")).isEqualTo((Object)"log");
        Assertions.assertThat((String)MoreFiles.fileExtension((String)"atlanmod..log")).isEqualTo((Object)"log");
        Assertions.assertThat((String)MoreFiles.fileExtension((String)".atlanmod.log")).isEqualTo((Object)"log");
        Assertions.assertThat((String)MoreFiles.fileExtension((String)"dir/atlanmod.log")).isEqualTo((Object)"log");
        Assertions.assertThat((String)MoreFiles.fileExtension((String)"atlanmod.tar.gz")).isEqualTo((Object)"gz");
        Assertions.assertThat((String)MoreFiles.fileExtension((String)"/")).isEmpty();
        Assertions.assertThat((String)MoreFiles.fileExtension((String)".")).isEmpty();
        Assertions.assertThat((String)MoreFiles.fileExtension((String)"..")).isEmpty();
        Assertions.assertThat((String)MoreFiles.fileExtension((String)"...")).isEmpty();
        Assertions.assertThat((String)MoreFiles.fileExtension((String)"atlanmod")).isEmpty();
        Assertions.assertThat((String)MoreFiles.fileExtension((String)"atlanmod.")).isEmpty();
        Assertions.assertThat((String)MoreFiles.fileExtension((String)".atlanmod.")).isEmpty();
        Assertions.assertThat((String)MoreFiles.fileExtension((String)"parent.dir/atlanmod")).isEmpty();
        Assertions.assertThat((String)MoreFiles.fileExtension((String)"parent/.dir/atlanmod")).isEmpty();
    }

    @Test
    public void testNameWithoutExtension() {
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)".log")).isEmpty();
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)"atlanmod.log")).isEqualTo((Object)"atlanmod");
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)"atlanmod..log")).isEqualTo((Object)"atlanmod.");
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)".atlanmod.log")).isEqualTo((Object)".atlanmod");
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)"dir/atlanmod.log")).isEqualTo((Object)"atlanmod");
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)"atlanmod.tar.gz")).isEqualTo((Object)"atlanmod.tar");
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)"/")).isEmpty();
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)".")).isEmpty();
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)"..")).isEqualTo((Object)".");
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)"...")).isEqualTo((Object)"..");
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)"atlanmod")).isEqualTo((Object)"atlanmod");
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)"atlanmod.")).isEqualTo((Object)"atlanmod");
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)".atlanmod.")).isEqualTo((Object)".atlanmod");
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)"parent.dir/atlanmod")).isEqualTo((Object)"atlanmod");
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)"parent/.dir/atlanmod")).isEqualTo((Object)"atlanmod");
    }
}

