/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.io.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.AbstractTest;
import org.atlanmod.commons.io.serializer.BinarySerializer;
import org.atlanmod.commons.io.serializer.Serializer;

@ParametersAreNonnullByDefault
public abstract class AbstractSerializerTest
extends AbstractTest {
    protected <T, U> T process(T value, Serializer<T, U> serializer) throws IOException {
        Object serialized = serializer.serialize(value);
        return (T)serializer.deserialize(serialized);
    }

    protected <T> T processWithStream(T value, BinarySerializer<T> serializer) throws IOException {
        byte[] data;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream out = new ObjectOutputStream(baos);){
            serializer.serialize(value, (DataOutput)out);
            out.flush();
            data = baos.toByteArray();
        }
        var5_4 = null;
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));){
            Object object = serializer.deserialize((DataInput)in);
            return (T)object;
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
    }
}

