/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.primitive;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.assertj.core.api.Assertions;
import org.atlanmod.commons.AbstractTest;
import org.atlanmod.commons.primitive.Booleans;
import org.atlanmod.commons.primitive.Bytes;
import org.atlanmod.commons.primitive.Strings;
import org.junit.jupiter.api.Test;

@ParametersAreNonnullByDefault
public class BytesTest
extends AbstractTest {
    @Test
    public void testToBoolean() {
        boolean actual0 = Bytes.toBoolean((byte[])Booleans.toBytes((Boolean)Boolean.TRUE));
        Assertions.assertThat((boolean)actual0).isTrue();
        boolean actual1 = Bytes.toBoolean((byte[])Booleans.toBytes((Boolean)Boolean.FALSE));
        Assertions.assertThat((boolean)actual1).isFalse();
    }

    @Test
    public void testToShort() {
        int expected0 = 28433;
        byte[] bytes = ByteBuffer.allocate(2).putShort((short)28433).array();
        short actual0 = Bytes.toShort((byte[])bytes);
        Assertions.assertThat((short)actual0).isEqualTo((short)28433);
    }

    @Test
    public void testToChar() {
        int expected0 = 78;
        byte[] bytes = ByteBuffer.allocate(2).putChar('N').array();
        char actual0 = Bytes.toChar((byte[])bytes);
        Assertions.assertThat((char)actual0).isEqualTo('N');
    }

    @Test
    public void testToInt() {
        int expected0 = 1654125381;
        byte[] bytes = ByteBuffer.allocate(4).putInt(1654125381).array();
        int actual0 = Bytes.toInt((byte[])bytes);
        Assertions.assertThat((int)actual0).isEqualTo(1654125381);
    }

    @Test
    public void testToLong() {
        long long0 = 1354566516474223156L;
        byte[] bytes = ByteBuffer.allocate(8).putLong(1354566516474223156L).array();
        long actual0 = Bytes.toLong((byte[])bytes);
        Assertions.assertThat((long)actual0).isEqualTo(1354566516474223156L);
    }

    @Test
    public void testToFloat() {
        float expected0 = 1.3989543E29f;
        byte[] bytes = ByteBuffer.allocate(4).putFloat(1.3989543E29f).array();
        float actual0 = Bytes.toFloat((byte[])bytes);
        Assertions.assertThat((float)actual0).isEqualTo(1.3989543E29f);
    }

    @Test
    public void testToDouble() {
        double expected0 = 1.9876412089108105E203;
        byte[] bytes = ByteBuffer.allocate(8).putDouble(1.9876412089108105E203).array();
        double actual0 = Bytes.toDouble((byte[])bytes);
        Assertions.assertThat((double)actual0).isEqualTo(1.9876412089108105E203);
    }

    @Test
    public void testToString() {
        String expected0 = "AtlanmodIsAwesome!";
        byte[] bytes = "AtlanmodIsAwesome!".getBytes();
        String actual0 = Bytes.toString((byte[])bytes);
        Assertions.assertThat((String)actual0).isEqualTo((Object)"AtlanmodIsAwesome!");
    }

    @Test
    public void testToStringBinaryAndReverse() {
        String expected0 = "AtlanmodIsAwesome!";
        byte[] bytes = Strings.toBytes((String)expected0);
        String actual0 = Bytes.toStringBinary((byte[])bytes);
        Assertions.assertThat((String)actual0).isEqualTo((Object)"41746c616e6d6f644973417765736f6d6521");
        byte[] actualBytes0 = Strings.toBytesBinary((String)actual0);
        Assertions.assertThat((byte[])actualBytes0).contains(bytes);
        Assertions.assertThat((String)Bytes.toString((byte[])actualBytes0)).isEqualTo((Object)expected0);
    }

    @Test
    public void testAsList() {
        byte[] bytes = new byte[]{1, 2, 3, 4, 5};
        List boxedList = Bytes.asList((byte[])bytes);
        Assertions.assertThat((int)boxedList.size()).isEqualTo(bytes.length);
        ArrayList<Byte> expected = new ArrayList<Byte>(bytes.length);
        for (byte each : bytes) {
            expected.add(each);
        }
        Assertions.assertThat(expected).isEqualTo((Object)boxedList);
    }

    @Test
    public void testToArray() {
        byte[] expected = new byte[]{1, 2, 3, 4, 5};
        ArrayList<Byte> boxedList = new ArrayList<Byte>();
        for (byte each : expected) {
            boxedList.add(each);
        }
        Assertions.assertThat((int)boxedList.size()).isEqualTo(expected.length);
        Assertions.assertThat((byte[])Bytes.toArray(boxedList)).isEqualTo((Object)expected);
    }
}

