/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons;

import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class LazyInt {
    @Nonnull
    private final IntSupplier loadFunction;
    private int value;
    private boolean isLoaded;

    private LazyInt(IntSupplier loadFunction) {
        this.loadFunction = loadFunction;
    }

    @Nonnull
    public static LazyInt of(int value) {
        return new LazyInt(() -> value);
    }

    @Nonnull
    public static LazyInt with(IntSupplier loadFunction) {
        return new LazyInt(loadFunction);
    }

    public int getAsInt() {
        if (!this.isLoaded) {
            this.update(this.loadFunction.getAsInt());
        }
        return this.value;
    }

    public void update(int newValue) {
        this.value = newValue;
        this.isLoaded = true;
    }

    public void update(IntUnaryOperator updateOperator) {
        this.value = updateOperator.applyAsInt(this.getAsInt());
        this.isLoaded = true;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void ifLoaded(IntConsumer consumer) {
        if (this.isLoaded) {
            consumer.accept(this.value);
        }
    }

    public void unload() {
        this.value = 0;
        this.isLoaded = false;
    }
}

