/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons;

import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.LongUnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class LazyLong {
    @Nonnull
    private final LongSupplier loadFunction;
    private long value;
    private boolean isLoaded;

    private LazyLong(LongSupplier loadFunction) {
        this.loadFunction = loadFunction;
    }

    @Nonnull
    public static LazyLong of(long value) {
        return new LazyLong(() -> value);
    }

    @Nonnull
    public static LazyLong with(LongSupplier loadFunction) {
        return new LazyLong(loadFunction);
    }

    public long getAsLong() {
        if (!this.isLoaded) {
            this.update(this.loadFunction.getAsLong());
        }
        return this.value;
    }

    public void update(long newValue) {
        this.value = newValue;
        this.isLoaded = true;
    }

    public void update(LongUnaryOperator updateOperator) {
        this.value = updateOperator.applyAsLong(this.getAsLong());
        this.isLoaded = true;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void ifLoaded(LongConsumer consumer) {
        if (this.isLoaded) {
            consumer.accept(this.value);
        }
    }

    public void unload() {
        this.value = 0L;
        this.isLoaded = false;
    }
}

