/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class LazyReference<T> {
    @Nonnull
    private final Supplier<T> refreshFunction;
    @Nullable
    private Reference<T> reference;
    private boolean isPresent;

    public LazyReference(Supplier<T> refreshFunction) {
        this.refreshFunction = refreshFunction;
    }

    public static <T> LazyReference<T> soft(Supplier<T> refreshFunction) {
        return new Soft<T>(refreshFunction);
    }

    public static <T> LazyReference<T> weak(Supplier<T> refreshFunction) {
        return new Weak<T>(refreshFunction);
    }

    public T get() {
        if (Objects.nonNull(this.reference)) {
            T value = this.reference.get();
            if (this.isPresent && Objects.isNull(value)) {
                return this.refresh();
            }
            return value;
        }
        return this.refresh();
    }

    public void update(@Nullable T newValue) {
        this.reference = this.newReference(newValue);
        this.isPresent = Objects.nonNull(newValue);
    }

    @Nullable
    private T refresh() {
        T value = this.refreshFunction.get();
        this.update(value);
        return value;
    }

    @Nonnull
    protected abstract Reference<T> newReference(@Nullable T var1);

    @ParametersAreNonnullByDefault
    private static final class Weak<T>
    extends LazyReference<T> {
        public Weak(Supplier<T> refreshFunction) {
            super(refreshFunction);
        }

        @Override
        @Nonnull
        protected Reference<T> newReference(@Nullable T value) {
            return new WeakReference<T>(value);
        }
    }

    @ParametersAreNonnullByDefault
    private static final class Soft<T>
    extends LazyReference<T> {
        public Soft(Supplier<T> refreshFunction) {
            super(refreshFunction);
        }

        @Override
        @Nonnull
        protected Reference<T> newReference(@Nullable T value) {
            return new SoftReference<T>(value);
        }
    }
}

