/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.ThreadSafe;
import org.atlanmod.commons.cache.CacheStats;

@ParametersAreNonnullByDefault
@ThreadSafe
public interface Cache<K, V> {
    public V get(K var1);

    public V get(K var1, Function<? super K, ? extends V> var2);

    @Nonnull
    public Map<K, V> getAll(Iterable<? extends K> var1);

    public void put(K var1, V var2);

    public void putIfAbsent(K var1, V var2);

    public void putAll(Map<? extends K, ? extends V> var1);

    public void invalidate(K var1);

    public void invalidateAll(Iterable<? extends K> var1);

    public void invalidateAll();

    public boolean contains(K var1);

    @Nonnegative
    public long size();

    public void refresh(K var1);

    public void cleanUp();

    @Nonnull
    public ConcurrentMap<K, V> asMap();

    @Nonnull
    public CacheStats stats();
}

