/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.cache;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Preconditions;
import org.atlanmod.commons.cache.Cache;
import org.atlanmod.commons.cache.CacheStats;

@ParametersAreNonnullByDefault
class CaffeineManualCache<C extends com.github.benmanes.caffeine.cache.Cache<K, V>, K, V>
implements Cache<K, V> {
    @Nonnull
    protected final C cache;

    protected CaffeineManualCache(C cache) {
        this.cache = cache;
    }

    @Override
    @Nullable
    public V get(K key) {
        Preconditions.checkNotNull(key, "key");
        return (V)this.cache.getIfPresent(key);
    }

    @Override
    public V get(K key, Function<? super K, ? extends V> mappingFunction) {
        Preconditions.checkNotNull(key, "key");
        Preconditions.checkNotNull(mappingFunction, "mappingFunction");
        return (V)this.cache.get(key, mappingFunction);
    }

    @Override
    @Nonnull
    public Map<K, V> getAll(Iterable<? extends K> keys) {
        Preconditions.checkNotNull(keys, "keys");
        return this.cache.getAllPresent(keys);
    }

    @Override
    public void put(K key, V value) {
        Preconditions.checkNotNull(key, "key");
        Preconditions.checkNotNull(value, "value");
        this.cache.put(key, value);
    }

    @Override
    public void putIfAbsent(K key, V value) {
        this.get(key, k -> value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Preconditions.checkNotNull(map, "map");
        this.cache.putAll(map);
    }

    @Override
    public void invalidate(K key) {
        Preconditions.checkNotNull(key, "key");
        this.cache.invalidate(key);
    }

    @Override
    public void invalidateAll(Iterable<? extends K> keys) {
        Preconditions.checkNotNull(keys, "keys");
        this.cache.invalidateAll(keys);
    }

    @Override
    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    @Override
    public boolean contains(K key) {
        return Objects.nonNull(this.get(key));
    }

    @Override
    public long size() {
        return this.cache.estimatedSize();
    }

    @Override
    public void refresh(K key) {
    }

    @Override
    public void cleanUp() {
        this.cache.cleanUp();
    }

    @Override
    @Nonnull
    public ConcurrentMap<K, V> asMap() {
        return this.cache.asMap();
    }

    @Override
    @Nonnull
    public CacheStats stats() {
        com.github.benmanes.caffeine.cache.stats.CacheStats stats = this.cache.stats();
        return new CacheStats(stats.hitCount(), stats.missCount(), stats.loadSuccessCount(), stats.loadFailureCount(), stats.totalLoadTime(), stats.evictionCount());
    }
}

