/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.collect;

import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Preconditions;

@ParametersAreNonnullByDefault
public class DelegatedIterator<T, R>
implements Iterator<R> {
    @Nonnull
    private final Iterator<T> delegate;
    @Nonnull
    private final Function<T, R> mappingFunction;

    public DelegatedIterator(Iterator<T> delegate, Function<T, R> mappingFunction) {
        Preconditions.checkNotNull(delegate, "delegate");
        Preconditions.checkNotNull(mappingFunction, "mappingFunction");
        this.delegate = delegate;
        this.mappingFunction = mappingFunction;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public R next() {
        return this.mappingFunction.apply(this.delegate.next());
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }
}

