/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.collect;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Preconditions;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.annotation.Static;
import org.atlanmod.commons.collect.MoreIterators;

@Static
@ParametersAreNonnullByDefault
public final class MoreIterables {
    private MoreIterables() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    @Nonnull
    public static <E> Stream<E> stream(@Nullable Iterable<E> iterable) {
        if (Objects.isNull(iterable)) {
            return Stream.empty();
        }
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    @Nonnull
    public static <E> Stream<E> parallelStream(@Nullable Iterable<E> iterable) {
        if (Objects.isNull(iterable)) {
            return Stream.empty();
        }
        return StreamSupport.stream(iterable.spliterator(), true);
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        Preconditions.checkNotNull(iterable, "iterable");
        return Collection.class.isInstance(iterable) ? ((Collection)Collection.class.cast(iterable)).isEmpty() : MoreIterators.isEmpty(iterable.iterator());
    }

    public static boolean notEmpty(Iterable<?> iterable) {
        return !MoreIterables.isEmpty(iterable);
    }

    @Nonnull
    public static <E> Optional<E> onlyElement(Iterable<E> iterable) {
        return MoreIterators.onlyElement(iterable.iterator());
    }

    @Nonnull
    public static <E> Optional<E> firstElement(Iterable<E> iterable) {
        return MoreIterators.firstElement(iterable.iterator());
    }
}

