/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.collect;

import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Preconditions;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.annotation.Static;

@Static
@ParametersAreNonnullByDefault
public final class MoreIterators {
    private MoreIterators() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    public static boolean isEmpty(Iterator<?> iterator) {
        Preconditions.checkNotNull(iterator, "iterator");
        return !iterator.hasNext();
    }

    public static boolean notEmpty(Iterator<?> iterator) {
        return !MoreIterators.isEmpty(iterator);
    }

    @Nonnull
    public static <E> Optional<E> onlyElement(Iterator<E> iterator) {
        Object first = null;
        if (iterator.hasNext()) {
            first = iterator.next();
            if (iterator.hasNext()) {
                throw new IllegalArgumentException("Expected one element in the iterator");
            }
        }
        return Optional.ofNullable(first);
    }

    @Nonnull
    public static <E> Optional<E> firstElement(Iterator<E> iterator) {
        return iterator.hasNext() ? Optional.of(iterator.next()) : Optional.empty();
    }
}

