/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.io;

import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Preconditions;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.annotation.Static;

@Static
@ParametersAreNonnullByDefault
public final class MoreFiles {
    private static final char DOT = '.';

    private MoreFiles() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    @Nonnull
    public static String fileExtension(File file) {
        Preconditions.checkNotNull(file, "file");
        String fileName = file.getName();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex + 1);
    }

    @Nonnull
    public static String fileExtension(String fullName) {
        Preconditions.checkNotNull(fullName, "fullName");
        return MoreFiles.fileExtension(new File(fullName));
    }

    @Nonnull
    public static String nameWithoutExtension(File file) {
        Preconditions.checkNotNull(file, "file");
        String fileName = file.getName();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
    }

    @Nonnull
    public static String nameWithoutExtension(String fullName) {
        Preconditions.checkNotNull(fullName, "fullName");
        return MoreFiles.nameWithoutExtension(new File(fullName));
    }
}

