/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.io.serializer;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.io.serializer.AbstractStringSerializer;
import org.atlanmod.commons.io.serializer.BinarySerializer;
import org.atlanmod.commons.primitive.Bytes;
import org.atlanmod.commons.primitive.Strings;

@ParametersAreNonnullByDefault
final class Base16Serializer<T>
extends AbstractStringSerializer<T> {
    protected Base16Serializer(@Nonnull BinarySerializer<T> serializer) {
        super(serializer);
    }

    @Override
    @Nonnull
    protected String encode(byte[] data) {
        return Bytes.toStringBinary(data);
    }

    @Override
    @Nonnull
    protected byte[] decode(String data) {
        return Strings.toBytesBinary(data);
    }
}

