/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.io.serializer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillNotClose;
import org.atlanmod.commons.Preconditions;
import org.atlanmod.commons.io.serializer.AbstractBinarySerializer;

@ParametersAreNonnullByDefault
final class ObjectBinarySerializer<T>
extends AbstractBinarySerializer<T> {
    private static final long serialVersionUID = 1069734448451637293L;

    ObjectBinarySerializer() {
    }

    @Override
    @Nonnull
    public byte[] serialize(T t) {
        return FST.asByteArray(t);
    }

    @Override
    @Nonnull
    public T deserialize(byte[] data) {
        return (T)FST.asObject(data);
    }

    @Override
    public void serialize(T t, @WillNotClose DataOutput out) throws IOException {
        Preconditions.checkInstanceOf(t, Serializable.class, "Requires a Serializable payload but received an object of type %s", t.getClass().getName());
        if (ObjectOutput.class.isInstance(out)) {
            this.serialize(t, (ObjectOutput)ObjectOutput.class.cast(out));
        } else if (OutputStream.class.isInstance(out)) {
            this.serialize(t, (OutputStream)OutputStream.class.cast(out));
        } else {
            throw new IllegalArgumentException(String.format("Unknown stream of type %s", out.getClass().getName()));
        }
    }

    @Override
    @Nonnull
    public T deserialize(@WillNotClose DataInput in) throws IOException {
        if (ObjectInput.class.isInstance(in)) {
            return this.deserialize((ObjectInput)ObjectInput.class.cast(in));
        }
        if (InputStream.class.isInstance(in)) {
            return this.deserialize((InputStream)InputStream.class.cast(in));
        }
        throw new IllegalArgumentException(String.format("Unknown stream of type %s", in.getClass().getName()));
    }

    private void serialize(T t, @WillNotClose ObjectOutput out) throws IOException {
        out.writeObject(t);
    }

    @Override
    @Nonnull
    private T deserialize(@WillNotClose ObjectInput in) throws IOException {
        try {
            return (T)in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }
}

