/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.io.serializer;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.io.serializer.Base16Serializer;
import org.atlanmod.commons.io.serializer.Base64Serializer;
import org.atlanmod.commons.io.serializer.BinarySerializer;
import org.atlanmod.commons.io.serializer.StringSerializer;

@ParametersAreNonnullByDefault
public final class StringSerializerFactory {
    private StringSerializerFactory() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    @Nonnull
    public static <T> StringSerializer<T> base16(BinarySerializer<T> serializer) {
        return new Base16Serializer<T>(serializer);
    }

    @Nonnull
    public static <T> StringSerializer<T> base64(BinarySerializer<T> serializer) {
        return new Base64Serializer<T>(serializer);
    }
}

