/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.log;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;
import javax.annotation.concurrent.ThreadSafe;
import org.atlanmod.commons.Lazy;
import org.atlanmod.commons.Preconditions;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.annotation.Static;
import org.atlanmod.commons.cache.Cache;
import org.atlanmod.commons.cache.CacheBuilder;
import org.atlanmod.commons.log.AsyncLogger;
import org.atlanmod.commons.log.Level;
import org.atlanmod.commons.log.Logger;

@Static
@ParametersAreNullableByDefault
@ThreadSafe
public final class Log {
    @Nonnull
    private static final Cache<String, Logger> LOGGERS = CacheBuilder.builder().softValues().build(AsyncLogger::new);
    @Nonnull
    private static final Lazy<Logger> ROOT = Lazy.with(() -> Log.forName(""));

    private Log() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    @Nonnull
    public static Logger root() {
        return ROOT.get();
    }

    @Nonnull
    public static Logger forName(@Nonnull String name) {
        return LOGGERS.get(Preconditions.checkNotNull(name, "name"));
    }

    public static void trace(Object obj) {
        Log.root().trace(obj);
    }

    public static void trace(CharSequence message) {
        Log.root().trace(message);
    }

    public static void trace(CharSequence message, Object ... params) {
        Log.root().trace(message, params);
    }

    public static void trace(Throwable e) {
        Log.root().trace(e);
    }

    public static void trace(Throwable e, CharSequence message) {
        Log.root().trace(e, message);
    }

    public static void trace(Throwable e, CharSequence message, Object ... params) {
        Log.root().trace(e, message, params);
    }

    public static void debug(Object obj) {
        Log.root().debug(obj);
    }

    public static void debug(CharSequence message) {
        Log.root().debug(message);
    }

    public static void debug(CharSequence message, Object ... params) {
        Log.root().debug(message, params);
    }

    public static void debug(Throwable e) {
        Log.root().debug(e);
    }

    public static void debug(Throwable e, CharSequence message) {
        Log.root().debug(e, message);
    }

    public static void debug(Throwable e, CharSequence message, Object ... params) {
        Log.root().debug(e, message, params);
    }

    public static void info(Object obj) {
        Log.root().info(obj);
    }

    public static void info(CharSequence message) {
        Log.root().info(message);
    }

    public static void info(CharSequence message, Object ... params) {
        Log.root().info(message, params);
    }

    public static void info(Throwable e) {
        Log.root().info(e);
    }

    public static void info(Throwable e, CharSequence message) {
        Log.root().info(e, message);
    }

    public static void info(Throwable e, CharSequence message, Object ... params) {
        Log.root().info(e, message, params);
    }

    public static void warn(Object obj) {
        Log.root().warn(obj);
    }

    public static void warn(CharSequence message) {
        Log.root().warn(message);
    }

    public static void warn(CharSequence message, Object ... params) {
        Log.root().warn(message, params);
    }

    public static void warn(Throwable e) {
        Log.root().warn(e);
    }

    public static void warn(Throwable e, CharSequence message) {
        Log.root().warn(e, message);
    }

    public static void warn(Throwable e, CharSequence message, Object ... params) {
        Log.root().warn(e, message, params);
    }

    public static void error(Object obj) {
        Log.root().error(obj);
    }

    public static void error(CharSequence message) {
        Log.root().error(message);
    }

    public static void error(CharSequence message, Object ... params) {
        Log.root().error(message, params);
    }

    public static void error(Throwable e) {
        Log.root().error(e);
    }

    public static void error(Throwable e, CharSequence message) {
        Log.root().error(e, message);
    }

    public static void error(Throwable e, CharSequence message, Object ... params) {
        Log.root().error(e, message, params);
    }

    public static void log(@Nonnull Level level, Object obj) {
        Log.root().log(level, obj);
    }

    public static void log(@Nonnull Level level, CharSequence message) {
        Log.root().log(level, message);
    }

    public static void log(@Nonnull Level level, CharSequence message, Object ... params) {
        Log.root().log(level, message, params);
    }

    public static void log(@Nonnull Level level, Throwable e) {
        Log.root().log(level, e);
    }

    public static void log(@Nonnull Level level, Throwable e, CharSequence message) {
        Log.root().log(level, e, message);
    }

    public static void log(@Nonnull Level level, Throwable e, CharSequence message, Object ... params) {
        Log.root().log(level, e, message, params);
    }
}

