/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.primitive;

import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Preconditions;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.annotation.Static;

@Static
@ParametersAreNonnullByDefault
public final class Bytes {
    private static final int BYTE_MASK = 255;
    private static final short HEX_MASK = 15;
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    private Bytes() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    public static boolean toBoolean(byte[] bytes) {
        Preconditions.checkNotNull(bytes, "bytes");
        Preconditions.checkEqualTo(bytes.length, 1, "bytes has wrong size: %d", bytes.length);
        return bytes[0] != 0;
    }

    public static short toShort(byte[] bytes) {
        Preconditions.checkNotNull(bytes, "bytes");
        Preconditions.checkEqualTo(bytes.length, 2, "bytes has wrong size: %d", bytes.length);
        short value = 0;
        boolean lenght = true;
        for (int i = 1; i >= 0; --i) {
            value = (short)(value | (bytes[i] & 0xFF) << 8 * (1 - i));
        }
        return value;
    }

    public static char toChar(byte[] bytes) {
        return (char)Bytes.toShort(bytes);
    }

    public static int toInt(byte[] bytes) {
        Preconditions.checkNotNull(bytes, "bytes");
        Preconditions.checkEqualTo(bytes.length, 4, "bytes has wrong size: %d", bytes.length);
        int value = 0;
        int lenght = 3;
        for (int i = 3; i >= 0; --i) {
            value |= (bytes[i] & 0xFF) << 8 * (3 - i);
        }
        return value;
    }

    public static long toLong(byte[] bytes) {
        Preconditions.checkNotNull(bytes, "bytes");
        Preconditions.checkEqualTo(bytes.length, 8, "bytes has wrong size: %d", bytes.length);
        long value = 0L;
        int lenght = 7;
        for (int i = 7; i >= 0; --i) {
            value |= ((long)bytes[i] & 0xFFL) << 8 * (7 - i);
        }
        return value;
    }

    public static float toFloat(byte[] bytes) {
        Preconditions.checkNotNull(bytes, "bytes");
        return Float.intBitsToFloat(Bytes.toInt(bytes));
    }

    public static double toDouble(byte[] bytes) {
        Preconditions.checkNotNull(bytes, "bytes");
        return Double.longBitsToDouble(Bytes.toLong(bytes));
    }

    @Nonnull
    public static String toString(byte[] bytes) {
        Preconditions.checkNotNull(bytes, "bytes");
        try {
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (UnsupportedCharsetException e) {
            throw Throwables.shouldNeverHappen(e);
        }
    }

    @Nonnull
    public static String toStringBinary(byte[] bytes) {
        Preconditions.checkNotNull(bytes, "bytes");
        char[] result = new char[bytes.length * 2];
        int i = 0;
        for (byte b : bytes) {
            result[i++] = HEX_DIGITS[b >> 4 & 0xF];
            result[i++] = HEX_DIGITS[b & 0xF];
        }
        return new String(result);
    }

    @Nonnull
    public static List<Byte> asList(byte ... primitiveArray) {
        Preconditions.checkNotNull(primitiveArray, "primitiveArray");
        if (primitiveArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Byte> byteCollection = new ArrayList<Byte>(primitiveArray.length);
        for (byte each : primitiveArray) {
            byteCollection.add(each);
        }
        return byteCollection;
    }

    @Nonnull
    public static byte[] toArray(List<Byte> boxedList) {
        Preconditions.checkNotNull(boxedList, "boxedList");
        int i = 0;
        byte[] elements = new byte[boxedList.size()];
        for (Byte each : boxedList) {
            elements[i++] = each;
        }
        return elements;
    }
}

