/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Preconditions;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.annotation.Builder;
import org.atlanmod.commons.annotation.Singleton;
import org.atlanmod.commons.annotation.Static;
import org.atlanmod.commons.reflect.ReflectionException;

@ParametersAreNonnullByDefault
public final class MoreReflection {
    private MoreReflection() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    @Nonnull
    public static <T> T newInstance(Class<T> type) {
        Object instance;
        Preconditions.checkNotNull(type, "type");
        Optional<String> methodName = MoreReflection.findConstructionMethod(type);
        try {
            if (methodName.isPresent()) {
                Method method = type.getMethod(methodName.get(), new Class[0]);
                method.setAccessible(true);
                instance = method.invoke(null, new Object[0]);
            } else {
                instance = type.newInstance();
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ReflectionException(e);
        }
        return instance;
    }

    @Nonnull
    private static Optional<String> findConstructionMethod(Class<?> type) {
        Preconditions.checkArgument(!type.isAnnotationPresent(Static.class), "%s is annotated with @%s: cannot be instantiated", type.getName(), Static.class.getSimpleName());
        Optional<String> methodName = type.isAnnotationPresent(Singleton.class) ? Optional.of(type.getAnnotation(Singleton.class).value()) : (type.isAnnotationPresent(Builder.class) ? Optional.of(type.getAnnotation(Builder.class).value()) : Optional.empty());
        return methodName;
    }

    @Nonnull
    public static Set<Class<?>> getAllInterfaces(Class<?> type) {
        LinkedHashSet interfaces = new LinkedHashSet();
        MoreReflection.appendAllInterfaces(type, interfaces);
        return interfaces;
    }

    private static void appendAllInterfaces(Class<?> type, Set<Class<?>> interfaces) {
        while (type != null) {
            Arrays.stream(type.getInterfaces()).filter(interfaces::add).forEachOrdered(i -> MoreReflection.appendAllInterfaces(i, interfaces));
            type = type.getSuperclass();
        }
    }
}

