/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons;

import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class Lazy<T> {
    @Nonnull
    private final Supplier<T> loadFunction;
    @Nullable
    private T value;
    private volatile boolean isLoaded;

    private Lazy(Supplier<T> loadFunction) {
        this.loadFunction = loadFunction;
    }

    @Nonnull
    public static <T> Lazy<T> of(T value) {
        return new Lazy<Object>(() -> value);
    }

    @Nonnull
    public static <T> Lazy<T> with(Supplier<T> loadFunction) {
        return new Lazy<T>(loadFunction);
    }

    public T get() {
        if (!this.isLoaded) {
            this.load();
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        Supplier<T> supplier = this.loadFunction;
        synchronized (supplier) {
            if (!this.isLoaded) {
                this.update(this.loadFunction.get());
            }
        }
    }

    public void update(@Nullable T newValue) {
        this.value = newValue;
        this.isLoaded = true;
    }

    public void update(UnaryOperator<T> updateOperator) {
        this.update(updateOperator.apply(this.get()));
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void ifLoaded(Consumer<T> consumer) {
        if (this.isLoaded) {
            consumer.accept(this.value);
        }
    }

    public void unload() {
        this.value = null;
        this.isLoaded = false;
    }
}

