/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons;

import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.annotation.Static;
import org.jetbrains.annotations.Contract;

@Static
@ParametersAreNonnullByDefault
public final class Preconditions {
    @Nullable
    private static final String NO_MESSAGE = null;
    @Nonnull
    private static final Object[] NO_PARAMS = new Object[0];

    private Preconditions() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    @Contract(value="false -> fail", pure=true)
    public static void checkArgument(boolean expression) {
        Preconditions.checkArgument(expression, NO_MESSAGE);
    }

    @Contract(value="false, _ -> fail", pure=true)
    public static void checkArgument(boolean expression, String message) {
        Preconditions.checkArgument(expression, message, NO_PARAMS);
    }

    @Contract(value="false, _, _ -> fail", pure=true)
    public static void checkArgument(boolean expression, String pattern, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(Preconditions.format(pattern, args));
        }
    }

    @Contract(value="false -> fail", pure=true)
    public static void checkState(boolean expression) {
        Preconditions.checkState(expression, NO_MESSAGE);
    }

    @Contract(value="false, _ -> fail", pure=true)
    public static void checkState(boolean expression, String message) {
        Preconditions.checkState(expression, message, NO_PARAMS);
    }

    @Contract(value="false, _, _ -> fail", pure=true)
    public static void checkState(boolean expression, String pattern, Object ... args) {
        if (!expression) {
            throw new IllegalStateException(Preconditions.format(pattern, args));
        }
    }

    @Nonnull
    @Contract(value="null -> fail", pure=true)
    public static <T> T checkNotNull(@Nullable T reference) {
        return Preconditions.checkNotNull(reference, NO_MESSAGE);
    }

    @Nonnull
    @Contract(value="null, _ -> fail", pure=true)
    public static <T> T checkNotNull(@Nullable T reference, String message) {
        return Preconditions.checkNotNull(reference, message, NO_PARAMS);
    }

    @Nonnull
    @Contract(value="null, _, _ -> fail", pure=true)
    public static <T> T checkNotNull(@Nullable T reference, String pattern, Object ... args) {
        if (null == reference) {
            throw new NullPointerException(Preconditions.format(pattern, args));
        }
        return reference;
    }

    @Nonnull
    public static <C extends Collection<? extends T>, T> C checkNotContainsNull(C collection) {
        return Preconditions.checkNotContainsNull(collection, "the collection contains at least one null element");
    }

    @Nonnull
    public static <C extends Collection<? extends T>, T> C checkNotContainsNull(C collection, String message) {
        return Preconditions.checkNotContainsNull(collection, message, NO_PARAMS);
    }

    @Nonnull
    public static <C extends Collection<? extends T>, T> C checkNotContainsNull(C collection, String pattern, Object ... args) {
        Preconditions.checkNotNull(collection, "collection");
        if (collection.contains(null)) {
            throw new NullPointerException(Preconditions.format(pattern, args));
        }
        return collection;
    }

    @Nonnull
    public static <T> T checkInstanceOf(T reference, Class<?> type) {
        return Preconditions.checkInstanceOf(reference, type, "object must be instance of '%s', but was '%s'", type.getName(), reference.getClass());
    }

    @Nonnull
    public static <T> T checkInstanceOf(T reference, Class<?> type, String message) {
        return Preconditions.checkInstanceOf(reference, type, message, NO_PARAMS);
    }

    @Nonnull
    public static <T> T checkInstanceOf(T reference, Class<?> type, String pattern, Object ... args) {
        Preconditions.checkNotNull(reference, "reference");
        Preconditions.checkNotNull(type, "type");
        if (!type.isInstance(reference)) {
            throw new IllegalArgumentException(Preconditions.format(pattern, args));
        }
        return reference;
    }

    public static <T> T checkEqualTo(@Nullable T value, @Nullable T other) {
        return Preconditions.checkEqualTo(value, other, "value (%s) must be equal to %s", value, other);
    }

    public static <T> T checkEqualTo(@Nullable T value, @Nullable T other, String message) {
        return Preconditions.checkEqualTo(value, other, message, NO_PARAMS);
    }

    public static <T> T checkEqualTo(@Nullable T value, @Nullable T other, String pattern, Object ... args) {
        if (!Objects.equals(value, other)) {
            throw new IllegalArgumentException(Preconditions.format(pattern, args));
        }
        return value;
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkGreaterThan(C value, C lowerBoundExclusive) {
        return Preconditions.checkGreaterThan(value, lowerBoundExclusive, "value (%s) must be greater than %s", value, lowerBoundExclusive);
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkGreaterThan(C value, C lowerBoundExclusive, String message) {
        return Preconditions.checkGreaterThan(value, lowerBoundExclusive, message, NO_PARAMS);
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkGreaterThan(C value, C lowerBoundExclusive, String pattern, Object ... args) {
        Preconditions.checkNotNull(value, "value");
        Preconditions.checkNotNull(lowerBoundExclusive, "lowerBoundExclusive");
        if (value.compareTo(lowerBoundExclusive) <= 0) {
            throw new IllegalArgumentException(Preconditions.format(pattern, args));
        }
        return value;
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkGreaterThanOrEqualTo(C value, C lowerBoundInclusive) {
        return Preconditions.checkGreaterThanOrEqualTo(value, lowerBoundInclusive, "value (%s) must not be less than %s", value, lowerBoundInclusive);
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkGreaterThanOrEqualTo(C value, C lowerBoundInclusive, String message) {
        return Preconditions.checkGreaterThanOrEqualTo(value, lowerBoundInclusive, message, NO_PARAMS);
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkGreaterThanOrEqualTo(C value, C lowerBoundInclusive, String pattern, Object ... args) {
        Preconditions.checkNotNull(value, "value");
        Preconditions.checkNotNull(lowerBoundInclusive, "lowerBoundInclusive");
        if (value.compareTo(lowerBoundInclusive) < 0) {
            throw new IllegalArgumentException(Preconditions.format(pattern, args));
        }
        return value;
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkLessThan(C value, C upperBoundExclusive) {
        return Preconditions.checkLessThan(value, upperBoundExclusive, "value (%s) must be less than %s", value, upperBoundExclusive);
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkLessThan(C value, C upperBoundExclusive, String message) {
        return Preconditions.checkLessThan(value, upperBoundExclusive, message, NO_PARAMS);
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkLessThan(C value, C upperBoundExclusive, String pattern, Object ... args) {
        Preconditions.checkNotNull(value, "value");
        Preconditions.checkNotNull(upperBoundExclusive, "upperBoundExclusive");
        if (value.compareTo(upperBoundExclusive) >= 0) {
            throw new IllegalArgumentException(Preconditions.format(pattern, args));
        }
        return value;
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkLessThanOrEqualTo(C value, C upperBoundInclusive) {
        return Preconditions.checkLessThanOrEqualTo(value, upperBoundInclusive, "value (%s) must not be greater than %s", value, upperBoundInclusive);
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkLessThanOrEqualTo(C value, C upperBoundInclusive, String message) {
        return Preconditions.checkLessThanOrEqualTo(value, upperBoundInclusive, message, NO_PARAMS);
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkLessThanOrEqualTo(C value, C upperBoundInclusive, String pattern, Object ... args) {
        Preconditions.checkNotNull(value, "value");
        Preconditions.checkNotNull(upperBoundInclusive, "upperBoundInclusive");
        if (value.compareTo(upperBoundInclusive) > 0) {
            throw new IllegalArgumentException(Preconditions.format(pattern, args));
        }
        return value;
    }

    @Nonnegative
    public static int checkElementIndex(@Nonnegative int index, @Nonnegative int size) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(Preconditions.format("index (%d) must not be negative", index));
        }
        if (size < 0) {
            throw new IllegalArgumentException(Preconditions.format("size (%d) must not be negative", size));
        }
        if (index >= size) {
            throw new IndexOutOfBoundsException(Preconditions.format("index (%d) must be less than size (%d)", index, size));
        }
        return index;
    }

    @Nonnegative
    public static int checkPositionIndex(@Nonnegative int index, @Nonnegative int size) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(Preconditions.format("index (%d) must not be negative", index));
        }
        if (size < 0) {
            throw new IllegalArgumentException(Preconditions.format("size (%d) must not be negative", size));
        }
        if (index > size) {
            throw new IndexOutOfBoundsException(Preconditions.format("index (%d) must not be greater than size (%d)", index, size));
        }
        return index;
    }

    @Nullable
    private static String format(String pattern, Object ... args) {
        return null != pattern ? String.format(pattern, args) : null;
    }
}

