/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.function.Function;
import java.util.function.ToIntBiFunction;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Preconditions;
import org.atlanmod.commons.cache.Cache;
import org.atlanmod.commons.cache.CacheBuilder;
import org.atlanmod.commons.cache.CaffeineLoadingCache;
import org.atlanmod.commons.cache.CaffeineManualCache;

@ParametersAreNonnullByDefault
final class CaffeineCacheBuilder<K, V>
implements CacheBuilder<K, V> {
    @Nonnull
    private final Caffeine<Object, Object> builder = Caffeine.newBuilder();

    protected CaffeineCacheBuilder() {
    }

    @Override
    @Nonnull
    public CacheBuilder<K, V> recordStats() {
        this.builder.recordStats();
        return this;
    }

    @Override
    @Nonnull
    public CacheBuilder<K, V> initialCapacity(int initialCapacity) {
        this.builder.initialCapacity(initialCapacity);
        return this;
    }

    @Override
    @Nonnull
    public CacheBuilder<K, V> maximumSize(@Nonnegative long maximumSize) {
        Preconditions.checkGreaterThanOrEqualTo(maximumSize, 0L, "maximumSize (%d) must not be negative", maximumSize);
        this.builder.maximumSize(maximumSize);
        return this;
    }

    @Override
    public <K1 extends K, V1 extends V> CacheBuilder<K, V> maximumWeight(@Nonnegative long maximumWeight, ToIntBiFunction<? super K1, ? extends V1> weigher) {
        Preconditions.checkGreaterThanOrEqualTo(maximumWeight, 0L, "maximumWeight (%d) must not be negative", maximumWeight);
        this.builder.maximumWeight(maximumWeight);
        this.builder.weigher(weigher::applyAsInt);
        return this;
    }

    @Override
    @Nonnull
    public CacheBuilder<K, V> weakKeys() {
        this.builder.weakKeys();
        return this;
    }

    @Override
    @Nonnull
    public CacheBuilder<K, V> weakValues() {
        this.builder.weakValues();
        return this;
    }

    @Override
    @Nonnull
    public CacheBuilder<K, V> softValues() {
        this.builder.softValues();
        return this;
    }

    @Override
    @Nonnull
    public <K1 extends K, V1 extends V> Cache<K1, V1> build() {
        return new CaffeineManualCache(this.builder.build());
    }

    @Override
    @Nonnull
    public <K1 extends K, V1 extends V> Cache<K1, V1> build(Function<? super K1, ? extends V1> mappingFunction) {
        Preconditions.checkNotNull(mappingFunction, "mappingFunction");
        return new CaffeineLoadingCache(this.builder.build(mappingFunction::apply));
    }
}

