/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.collect;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.atlanmod.commons.Preconditions;
import org.atlanmod.commons.collect.MoreIterables;

@ParametersAreNonnullByDefault
@FunctionalInterface
@Immutable
public interface Range<C extends Comparable<C>> {
    @Nonnull
    public static <C extends Comparable<C>> Range<C> open(C lower, C upper) {
        Preconditions.checkNotNull(lower, "lower");
        Preconditions.checkNotNull(upper, "upper");
        Preconditions.checkLessThanOrEqualTo(lower, upper, "upper (%d) must not be less than lower (%d)", upper, lower);
        return v -> v.compareTo(lower) > 0 && v.compareTo(upper) < 0;
    }

    @Nonnull
    public static <C extends Comparable<C>> Range<C> closed(C lower, C upper) {
        Preconditions.checkNotNull(lower, "lower");
        Preconditions.checkNotNull(upper, "upper");
        Preconditions.checkLessThanOrEqualTo(lower, upper, "upper (%d) must not be less than lower (%d)", upper, lower);
        return v -> v.compareTo(lower) >= 0 && v.compareTo(upper) <= 0;
    }

    @Nonnull
    public static <C extends Comparable<C>> Range<C> openClosed(C lower, C upper) {
        Preconditions.checkNotNull(lower, "lower");
        Preconditions.checkNotNull(upper, "upper");
        Preconditions.checkLessThanOrEqualTo(lower, upper, "upper (%d) must not be less than lower (%d)", upper, lower);
        return v -> v.compareTo(lower) > 0 && v.compareTo(upper) <= 0;
    }

    @Nonnull
    public static <C extends Comparable<C>> Range<C> closedOpen(C lower, C upper) {
        Preconditions.checkNotNull(lower, "lower");
        Preconditions.checkNotNull(upper, "upper");
        Preconditions.checkLessThanOrEqualTo(lower, upper, "upper (%d) must not be less than lower (%d)", upper, lower);
        return v -> v.compareTo(lower) >= 0 && v.compareTo(upper) < 0;
    }

    @Nonnull
    public static <C extends Comparable<C>> Range<C> singleton(C value) {
        return Range.closed(value, value);
    }

    @Nonnull
    public static <C extends Comparable<C>> Range<C> atLeast(C lower) {
        Preconditions.checkNotNull(lower, "lower");
        return v -> v.compareTo(lower) >= 0;
    }

    @Nonnull
    public static <C extends Comparable<C>> Range<C> atMost(C upper) {
        Preconditions.checkNotNull(upper, "upper");
        return v -> v.compareTo(upper) <= 0;
    }

    @Nonnull
    public static <C extends Comparable<C>> Range<C> greaterThan(C lower) {
        Preconditions.checkNotNull(lower, "lower");
        return v -> v.compareTo(lower) > 0;
    }

    @Nonnull
    public static <C extends Comparable<C>> Range<C> lessThan(C upper) {
        Preconditions.checkNotNull(upper, "upper");
        return v -> v.compareTo(upper) < 0;
    }

    @Nonnull
    public static <C extends Comparable<C>> Range<C> all() {
        return v -> true;
    }

    @Nonnull
    public static <C extends Comparable<C>> Range<C> empty() {
        return v -> false;
    }

    @Nonnull
    public static <C extends Comparable<C>> Range<C> and(Range<C> r1, Range<C> r2) {
        Preconditions.checkNotNull(r1, "r1");
        Preconditions.checkNotNull(r2, "r2");
        return v -> Boolean.logicalAnd(r1.contains(v), r2.contains(v));
    }

    @Nonnull
    public static <C extends Comparable<C>> Range<C> or(Range<C> r1, Range<C> r2) {
        Preconditions.checkNotNull(r1, "r1");
        Preconditions.checkNotNull(r2, "r2");
        return v -> Boolean.logicalOr(r1.contains(v), r2.contains(v));
    }

    @Nonnull
    public static <C extends Comparable<C>> Range<C> xor(Range<C> r1, Range<C> r2) {
        Preconditions.checkNotNull(r1, "r1");
        Preconditions.checkNotNull(r2, "r2");
        return v -> Boolean.logicalXor(r1.contains(v), r2.contains(v));
    }

    public boolean contains(C var1);

    default public boolean containsAll(Iterable<? extends C> values) {
        Preconditions.checkNotNull(values, "values");
        return MoreIterables.stream(values).allMatch(this::contains);
    }
}

