/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.hash;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.openhft.hashing.LongHashFunction;
import org.atlanmod.commons.hash.HashCode;
import org.atlanmod.commons.hash.Hasher;
import org.atlanmod.commons.hash.LongHashCode;

@ParametersAreNonnullByDefault
final class ZeroAllocationHasher
implements Hasher {
    @Nonnull
    private final LongHashFunction delegate;

    public ZeroAllocationHasher(LongHashFunction delegate) {
        this.delegate = delegate;
    }

    @Override
    @Nonnull
    public HashCode hash(byte data) {
        return this.createHashCode(this.delegate.hashByte(data));
    }

    @Override
    @Nonnull
    public HashCode hash(boolean data) {
        return this.createHashCode(this.delegate.hashBoolean(data));
    }

    @Override
    @Nonnull
    public HashCode hash(char data) {
        return this.createHashCode(this.delegate.hashChar(data));
    }

    @Override
    @Nonnull
    public HashCode hash(short data) {
        return this.createHashCode(this.delegate.hashShort(data));
    }

    @Override
    @Nonnull
    public HashCode hash(int data) {
        return this.createHashCode(this.delegate.hashInt(data));
    }

    @Override
    @Nonnull
    public HashCode hash(long data) {
        return this.createHashCode(this.delegate.hashLong(data));
    }

    @Override
    @Nonnull
    public HashCode hash(float data) {
        return this.createHashCode(this.delegate.hashInt(Float.floatToRawIntBits(data)));
    }

    @Override
    @Nonnull
    public HashCode hash(double data) {
        return this.createHashCode(this.delegate.hashLong(Double.doubleToRawLongBits(data)));
    }

    @Override
    @Nonnull
    public HashCode hash(String data) {
        return this.createHashCode(this.delegate.hashChars(data));
    }

    @Override
    @Nonnull
    public HashCode hash(byte[] data) {
        return this.createHashCode(this.delegate.hashBytes(data));
    }

    @Nonnull
    private HashCode createHashCode(long hashCode) {
        return new LongHashCode(hashCode);
    }
}

