/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.io.serializer;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Preconditions;
import org.atlanmod.commons.io.serializer.BinarySerializer;
import org.atlanmod.commons.io.serializer.StringSerializer;

@ParametersAreNonnullByDefault
public abstract class AbstractStringSerializer<T>
implements StringSerializer<T> {
    @Nonnull
    private final BinarySerializer<T> serializer;

    protected AbstractStringSerializer(@Nonnull BinarySerializer<T> serializer) {
        Preconditions.checkNotNull(serializer, "serializer");
        this.serializer = serializer;
    }

    @Override
    @Nonnull
    public String serialize(T t) {
        return this.encode((byte[])this.serializer.convert(t));
    }

    @Override
    @Nonnull
    public T deserialize(String data) {
        return this.serializer.revert(this.decode(data));
    }

    @Nonnull
    protected abstract String encode(byte[] var1);

    @Nonnull
    protected abstract byte[] decode(String var1);
}

