/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.log;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.atlanmod.commons.log.Level;

@FunctionalInterface
@ParametersAreNullableByDefault
@ThreadSafe
@Immutable
public interface Logger {
    @Nullable
    public static final Throwable NO_EXCEPTION = null;
    @Nullable
    public static final CharSequence NO_MESSAGE = null;
    @Nonnull
    public static final Object[] NO_PARAMS = new Object[0];

    default public void trace(Object obj) {
        this.trace(String.valueOf(obj));
    }

    default public void trace(CharSequence message) {
        this.trace(NO_EXCEPTION, message, NO_PARAMS);
    }

    default public void trace(CharSequence message, Object ... params) {
        this.trace(NO_EXCEPTION, message, params);
    }

    default public void trace(Throwable e) {
        this.trace(e, NO_MESSAGE, NO_PARAMS);
    }

    default public void trace(Throwable e, CharSequence message) {
        this.trace(e, message, NO_PARAMS);
    }

    default public void trace(Throwable e, CharSequence message, Object ... params) {
        this.log(Level.TRACE, e, message, params);
    }

    default public void debug(Object obj) {
        this.debug(String.valueOf(obj));
    }

    default public void debug(CharSequence message) {
        this.debug(NO_EXCEPTION, message, NO_PARAMS);
    }

    default public void debug(CharSequence message, Object ... params) {
        this.debug(NO_EXCEPTION, message, params);
    }

    default public void debug(Throwable e) {
        this.debug(e, NO_MESSAGE, NO_PARAMS);
    }

    default public void debug(Throwable e, CharSequence message) {
        this.debug(e, message, NO_PARAMS);
    }

    default public void debug(Throwable e, CharSequence message, Object ... params) {
        this.log(Level.DEBUG, e, message, params);
    }

    default public void info(Object obj) {
        this.info(String.valueOf(obj));
    }

    default public void info(CharSequence message) {
        this.info(NO_EXCEPTION, message, NO_PARAMS);
    }

    default public void info(CharSequence message, Object ... params) {
        this.info(NO_EXCEPTION, message, params);
    }

    default public void info(Throwable e) {
        this.info(e, NO_MESSAGE, NO_PARAMS);
    }

    default public void info(Throwable e, CharSequence message) {
        this.info(e, message, NO_PARAMS);
    }

    default public void info(Throwable e, CharSequence message, Object ... params) {
        this.log(Level.INFO, e, message, params);
    }

    default public void warn(Object obj) {
        this.warn(String.valueOf(obj));
    }

    default public void warn(CharSequence message) {
        this.warn(NO_EXCEPTION, message, NO_PARAMS);
    }

    default public void warn(CharSequence message, Object ... params) {
        this.warn(NO_EXCEPTION, message, params);
    }

    default public void warn(Throwable e) {
        this.warn(e, NO_MESSAGE, NO_PARAMS);
    }

    default public void warn(Throwable e, CharSequence message) {
        this.warn(e, message, NO_PARAMS);
    }

    default public void warn(Throwable e, CharSequence message, Object ... params) {
        this.log(Level.WARN, e, message, params);
    }

    default public void error(Object obj) {
        this.error(String.valueOf(obj));
    }

    default public void error(CharSequence message) {
        this.error(NO_EXCEPTION, message, NO_PARAMS);
    }

    default public void error(CharSequence message, Object ... params) {
        this.error(NO_EXCEPTION, message, params);
    }

    default public void error(Throwable e) {
        this.error(e, NO_MESSAGE, NO_PARAMS);
    }

    default public void error(Throwable e, CharSequence message) {
        this.error(e, message, NO_PARAMS);
    }

    default public void error(Throwable e, CharSequence message, Object ... params) {
        this.log(Level.ERROR, e, message, params);
    }

    default public void log(@Nonnull Level level, Object obj) {
        this.log(level, String.valueOf(obj));
    }

    default public void log(@Nonnull Level level, CharSequence message) {
        this.log(level, NO_EXCEPTION, message, NO_PARAMS);
    }

    default public void log(@Nonnull Level level, CharSequence message, Object ... params) {
        this.log(level, NO_EXCEPTION, message, params);
    }

    default public void log(@Nonnull Level level, Throwable e) {
        this.log(level, e, NO_MESSAGE, NO_PARAMS);
    }

    default public void log(@Nonnull Level level, Throwable e, CharSequence message) {
        this.log(level, e, message, NO_PARAMS);
    }

    public void log(@Nonnull Level var1, Throwable var2, CharSequence var3, Object ... var4);
}

