/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.primitive;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Preconditions;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.annotation.Static;
import org.atlanmod.commons.primitive.Ints;

@Static
@ParametersAreNonnullByDefault
public final class Floats {
    private Floats() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    @Nonnull
    public static byte[] toBytes(float value) {
        return Ints.toBytes(Float.floatToIntBits(value));
    }

    @Nonnull
    public static byte[] toBytes(Float value) {
        Preconditions.checkNotNull(value, "value");
        return Floats.toBytes(value.floatValue());
    }
}

