/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.service;

import java.util.ServiceLoader;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.collect.MoreIterables;
import org.atlanmod.commons.service.ServiceContext;
import org.atlanmod.commons.service.ServiceDefinition;

@ParametersAreNonnullByDefault
public class ServiceLoaderContext
implements ServiceContext {
    @Nonnull
    public <S> Stream<ServiceDefinition<S>> getServices(Class<S> type) {
        ClassLoader classLoader = type.getClassLoader();
        ServiceLoader<S> serviceLoader = ServiceLoader.load(type, classLoader);
        return MoreIterables.parallelStream(serviceLoader).map(DirectServiceDefinition::new);
    }

    @ParametersAreNonnullByDefault
    private static class DirectServiceDefinition<S>
    implements ServiceDefinition<S> {
        @Nonnull
        private final S service;

        public DirectServiceDefinition(S service) {
            this.service = service;
        }

        @Override
        @Nonnull
        public Class<? extends S> type() {
            return this.service.getClass();
        }

        @Override
        @Nonnull
        public S get() {
            return this.service;
        }
    }
}

