/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.ParametersAreNonnullByDefault;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.atlanmod.commons.AbstractTest;
import org.atlanmod.commons.Preconditions;
import org.junit.jupiter.api.Test;

@ParametersAreNonnullByDefault
class PreconditionsTest
extends AbstractTest {
    PreconditionsTest() {
    }

    @Test
    void testConstructor() throws Exception {
        Constructor constructor = Preconditions.class.getDeclaredConstructor(new Class[0]);
        Assertions.assertThat((boolean)Modifier.isPrivate(constructor.getModifiers())).isTrue();
        constructor.setAccessible(true);
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> constructor.newInstance(new Object[0]))).isInstanceOf(InvocationTargetException.class)).hasCauseExactlyInstanceOf(IllegalStateException.class);
    }

    @Test
    void testCheckArgument() {
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkArgument((boolean)true))).isNull();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkArgument((boolean)false))).isExactlyInstanceOf(IllegalArgumentException.class)).hasNoCause().hasMessage(null);
    }

    @Test
    void testCheckArgumentWithMessage() {
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkArgument((boolean)true, (String)"Message0"))).isNull();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkArgument((boolean)false, (String)"Message0"))).isExactlyInstanceOf(IllegalArgumentException.class)).hasNoCause().hasMessage("Message0");
    }

    @Test
    void testCheckArgumentWithPattern() {
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkArgument((boolean)true, (String)"Message%d", (Object[])new Object[]{0}))).isNull();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkArgument((boolean)false, (String)"Message%d", (Object[])new Object[]{0}))).isExactlyInstanceOf(IllegalArgumentException.class)).hasNoCause().hasMessage("Message0");
    }

    @Test
    void testCheckState() {
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkState((boolean)true))).isNull();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkState((boolean)false))).isExactlyInstanceOf(IllegalStateException.class)).hasNoCause().hasMessage(null);
    }

    @Test
    void testCheckStateWithMessage() {
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkState((boolean)true, (String)"Message0"))).isNull();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkState((boolean)false, (String)"Message0"))).isExactlyInstanceOf(IllegalStateException.class)).hasNoCause().hasMessage("Message0");
    }

    @Test
    void testCheckStateWithPattern() {
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkState((boolean)true, (String)"Message%d", (Object[])new Object[]{0}))).isNull();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkState((boolean)false, (String)"Message%d", (Object[])new Object[]{0}))).isExactlyInstanceOf(IllegalStateException.class)).hasNoCause().hasMessage("Message0");
    }

    @Test
    void testCheckNotNull() {
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkNotNull((Object)new Object()))).isNull();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkNotNull(null))).isExactlyInstanceOf(NullPointerException.class)).hasNoCause().hasMessage(null);
    }

    @Test
    void testCheckNotNullWithMessage() {
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkNotNull((Object)new Object(), (String)"Message0"))).isNull();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkNotNull(null, (String)"Message0"))).isExactlyInstanceOf(NullPointerException.class)).hasNoCause().hasMessage("Message0");
    }

    @Test
    void testCheckNotNullWithPattern() {
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkNotNull((Object)new Object(), (String)"Message%d", (Object[])new Object[]{0}))).isNull();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkNotNull(null, (String)"Message%d", (Object[])new Object[]{0}))).isExactlyInstanceOf(NullPointerException.class)).hasNoCause().hasMessage("Message0");
    }

    @Test
    void testCheckNotContainsNull() {
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkNotContainsNull(Collections.emptyList()))).isNull();
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkNotContainsNull(Collections.singletonList(0)))).isNull();
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkNotContainsNull(Arrays.asList(0, 1, 2, 3)))).isNull();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkNotContainsNull(Arrays.asList(0, 1, null, 2)))).isExactlyInstanceOf(NullPointerException.class)).hasNoCause().hasMessage("the collection contains at least one null element");
    }

    @Test
    void testCheckElementIndex() {
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkElementIndex((int)-1, (int)0))).isExactlyInstanceOf(IndexOutOfBoundsException.class)).hasNoCause().hasMessage("index (-1) must not be negative");
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkElementIndex((int)0, (int)-1))).isExactlyInstanceOf(IllegalArgumentException.class)).hasNoCause().hasMessage("size (-1) must not be negative");
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkElementIndex((int)0, (int)0))).isExactlyInstanceOf(IndexOutOfBoundsException.class)).hasNoCause().hasMessage("index (0) must be less than size (0)");
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkElementIndex((int)0, (int)1))).isNull();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkElementIndex((int)1, (int)0))).isExactlyInstanceOf(IndexOutOfBoundsException.class)).hasNoCause().hasMessage("index (1) must be less than size (0)");
    }

    @Test
    void testCheckPositionIndex() {
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkPositionIndex((int)-1, (int)0))).isExactlyInstanceOf(IndexOutOfBoundsException.class)).hasNoCause().hasMessage("index (-1) must not be negative");
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkPositionIndex((int)0, (int)-1))).isExactlyInstanceOf(IllegalArgumentException.class)).hasNoCause().hasMessage("size (-1) must not be negative");
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkPositionIndex((int)0, (int)0))).isNull();
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkPositionIndex((int)0, (int)1))).isNull();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkPositionIndex((int)1, (int)0))).isExactlyInstanceOf(IndexOutOfBoundsException.class)).hasNoCause().hasMessage("index (1) must not be greater than size (0)");
    }

    @Test
    void testCheckEqualTo() {
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkEqualTo(null, null))).isNull();
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkEqualTo((Object)10, (Object)10))).isNull();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkEqualTo((Object)10, (Object)0))).isExactlyInstanceOf(IllegalArgumentException.class)).hasNoCause().hasMessage("value (10) must be equal to 0");
    }

    @Test
    void testCheckLessThan() {
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkLessThan((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(9)))).isExactlyInstanceOf(IllegalArgumentException.class)).hasNoCause().hasMessage("value (10) must be less than 9");
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkLessThan((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(10)))).isExactlyInstanceOf(IllegalArgumentException.class)).hasNoCause().hasMessage("value (10) must be less than 10");
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkLessThan((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(11)))).isNull();
    }

    @Test
    void testCheckLessThanOrEqualTo() {
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkLessThanOrEqualTo((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(9)))).isExactlyInstanceOf(IllegalArgumentException.class)).hasNoCause().hasMessage("value (10) must not be greater than 9");
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkLessThanOrEqualTo((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(10)))).isNull();
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkLessThanOrEqualTo((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(11)))).isNull();
    }

    @Test
    void testCheckGreaterThan() {
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkGreaterThan((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(9)))).isNull();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkGreaterThan((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(10)))).isExactlyInstanceOf(IllegalArgumentException.class)).hasNoCause().hasMessage("value (10) must be greater than 10");
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkGreaterThan((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(11)))).isExactlyInstanceOf(IllegalArgumentException.class)).hasNoCause().hasMessage("value (10) must be greater than 11");
    }

    @Test
    void testCheckGreaterThanOrEqualTo() {
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkGreaterThanOrEqualTo((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(9)))).isNull();
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkGreaterThanOrEqualTo((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(10)))).isNull();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> Preconditions.checkGreaterThanOrEqualTo((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(11)))).isExactlyInstanceOf(IllegalArgumentException.class)).hasNoCause().hasMessage("value (10) must not be less than 11");
    }
}

