/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.ParametersAreNonnullByDefault;
import org.assertj.core.api.Assertions;
import org.atlanmod.commons.AbstractTest;
import org.atlanmod.commons.cache.Cache;
import org.atlanmod.commons.cache.CacheBuilder;
import org.atlanmod.commons.cache.CacheStats;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@ParametersAreNonnullByDefault
class CacheTest
extends AbstractTest {
    private Cache<Integer, String> cache;

    CacheTest() {
    }

    @BeforeEach
    void setUp() {
        this.cache = CacheBuilder.builder().weakKeys().softValues().maximumSize(5L).recordStats().build();
        Assertions.assertThat((long)this.cache.size()).isEqualTo(0L);
    }

    @AfterEach
    void tearDown() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    @Test
    void createCacheInvalidSize() {
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> CacheBuilder.builder().maximumSize(-1L))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testGetPut() {
        String value0 = "Value0";
        this.cache.put((Object)0, (Object)value0);
        Assertions.assertThat((String)((String)this.cache.get((Object)0))).isEqualTo(value0);
        Assertions.assertThat((long)this.cache.size()).isEqualTo(1L);
    }

    @Test
    void testGetAbsent() {
        Assertions.assertThat((String)((String)this.cache.get((Object)0))).isNull();
    }

    @Test
    void testGetWithFunction() {
        String prefix = "Value";
        String value0 = prefix + '0';
        Assertions.assertThat((String)((String)this.cache.get((Object)0))).isNull();
        Assertions.assertThat((long)this.cache.size()).isEqualTo(0L);
        Assertions.assertThat((String)((String)this.cache.get((Object)0, key -> prefix + key))).isEqualTo(value0);
        Assertions.assertThat((long)this.cache.size()).isEqualTo(1L);
        Assertions.assertThat((String)((String)this.cache.get((Object)0))).isEqualTo(value0);
    }

    @Test
    void testGetWithNullFunction() {
        Assertions.assertThat((String)((String)this.cache.get((Object)0))).isNull();
        Assertions.assertThat((String)((String)this.cache.get((Object)0, key -> null))).isNull();
        Assertions.assertThat((String)((String)this.cache.get((Object)0))).isNull();
        this.cache.refresh((Object)0);
        Assertions.assertThat((String)((String)this.cache.get((Object)0))).isNull();
    }

    @Test
    void testGetPutAllKeys() {
        String value0 = "Value0";
        String value1 = "Value1";
        String value2 = "Value2";
        HashMap<Integer, String> original = new HashMap<Integer, String>();
        original.put(0, value0);
        original.put(1, value1);
        original.put(2, value2);
        this.cache.putAll(original);
        Assertions.assertThat((long)this.cache.size()).isEqualTo(3L);
        Assertions.assertThat((String)((String)this.cache.get((Object)0))).isEqualTo(value0);
        Assertions.assertThat((String)((String)this.cache.get((Object)1))).isEqualTo(value1);
        Assertions.assertThat((String)((String)this.cache.get((Object)2))).isEqualTo(value2);
        Map result = this.cache.getAll((Iterable)IntStream.of(0, 2).boxed().collect(Collectors.toList()));
        Assertions.assertThat((String)((String)result.get(0))).isEqualTo(value0);
        Assertions.assertThat((String)((String)result.get(2))).isEqualTo(value2);
    }

    @Test
    void testInvalidate() {
        String value0 = "Value0";
        String value1 = "Value1";
        this.cache.put((Object)0, (Object)value0);
        this.cache.put((Object)1, (Object)value1);
        Assertions.assertThat((String)((String)this.cache.get((Object)0))).isEqualTo(value0);
        Assertions.assertThat((String)((String)this.cache.get((Object)1))).isEqualTo(value1);
        Assertions.assertThat((long)this.cache.size()).isEqualTo(2L);
        this.cache.invalidate((Object)0);
        Assertions.assertThat((String)((String)this.cache.get((Object)0))).isNull();
        Assertions.assertThat((String)((String)this.cache.get((Object)1))).isEqualTo(value1);
        Assertions.assertThat((long)this.cache.size()).isEqualTo(1L);
    }

    @Test
    void testInvalidateAllKeys() {
        String value0 = "Value0";
        String value1 = "Value1";
        String value2 = "Value2";
        this.cache.put((Object)0, (Object)value0);
        this.cache.put((Object)1, (Object)value1);
        this.cache.put((Object)2, (Object)value2);
        Assertions.assertThat((long)this.cache.size()).isEqualTo(3L);
        Assertions.assertThat((String)((String)this.cache.get((Object)0))).isEqualTo(value0);
        Assertions.assertThat((String)((String)this.cache.get((Object)1))).isEqualTo(value1);
        Assertions.assertThat((String)((String)this.cache.get((Object)2))).isEqualTo(value2);
        this.cache.invalidateAll((Iterable)IntStream.of(0, 2).boxed().collect(Collectors.toList()));
        Assertions.assertThat((long)this.cache.size()).isEqualTo(1L);
        Assertions.assertThat((String)((String)this.cache.get((Object)0))).isNull();
        Assertions.assertThat((String)((String)this.cache.get((Object)1))).isEqualTo(value1);
        Assertions.assertThat((String)((String)this.cache.get((Object)2))).isNull();
    }

    @Test
    void testInvalidateAll() {
        String value0 = "Value0";
        String value1 = "Value1";
        this.cache.put((Object)0, (Object)value0);
        this.cache.put((Object)1, (Object)value1);
        Assertions.assertThat((long)this.cache.size()).isEqualTo(2L);
        Assertions.assertThat((String)((String)this.cache.get((Object)0))).isEqualTo(value0);
        Assertions.assertThat((String)((String)this.cache.get((Object)1))).isEqualTo(value1);
        this.cache.invalidateAll();
        Assertions.assertThat((long)this.cache.size()).isEqualTo(0L);
        Assertions.assertThat((String)((String)this.cache.get((Object)0))).isNull();
        Assertions.assertThat((String)((String)this.cache.get((Object)1))).isNull();
    }

    @Test
    void asMap() throws Exception {
        String value0 = "Value0";
        String value1 = "Value1";
        String value2 = "Value2";
        HashMap<Integer, String> original = new HashMap<Integer, String>();
        original.put(0, value0);
        original.put(1, value1);
        original.put(2, value2);
        this.cache.putAll(original);
        ConcurrentMap result = this.cache.asMap();
        original.forEach((key, value) -> Assertions.assertThat((String)((String)result.get(key))).isEqualTo(value));
    }

    @Test
    void stats() throws Exception {
        CacheStats stats = this.cache.stats();
        Assertions.assertThat((Object)stats).isNotNull();
    }
}

