/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.collect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import javax.annotation.ParametersAreNonnullByDefault;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.atlanmod.commons.AbstractTest;
import org.atlanmod.commons.collect.MoreArrays;
import org.junit.jupiter.api.Test;

@ParametersAreNonnullByDefault
class MoreArraysTest
extends AbstractTest {
    MoreArraysTest() {
    }

    @Test
    void testConstructor() throws Exception {
        Constructor constructor = MoreArrays.class.getDeclaredConstructor(new Class[0]);
        Assertions.assertThat((boolean)Modifier.isPrivate(constructor.getModifiers())).isTrue();
        constructor.setAccessible(true);
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> constructor.newInstance(new Object[0]))).isInstanceOf(InvocationTargetException.class)).hasCauseExactlyInstanceOf(IllegalStateException.class);
    }

    @Test
    void testNewArray() {
        Object[] array0 = MoreArrays.newArray(Object.class, (int)1);
        Assertions.assertThat((Object[])array0).isExactlyInstanceOf(Object[].class);
        Assertions.assertThat((Object[])array0).hasSize(1);
        Object[] array1 = (String[])MoreArrays.newArray(String.class, (int)2);
        Assertions.assertThat((Object[])array1).isExactlyInstanceOf(String[].class);
        Assertions.assertThat((Object[])array1).hasSize(2);
    }

    @Test
    void testInvalidNewArray() {
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> MoreArrays.newArray(null, (int)0))).isExactlyInstanceOf(NullPointerException.class);
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> MoreArrays.newArray(Object.class, (int)-1))).isExactlyInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testResize() {
        Object[] array0 = new Integer[]{0, 1, 2, 3};
        Assertions.assertThat((Object[])array0).hasSize(4);
        Object[] array1 = (Integer[])MoreArrays.resize((Object[])array0, (int)5);
        Assertions.assertThat((Object[])array0).hasSize(4);
        Assertions.assertThat((Object[])array1).hasSize(5);
        Assertions.assertThat((Object[])array1).containsExactly((Object[])new Integer[]{0, 1, 2, 3, null});
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> MoreArraysTest.lambda$testResize$3((Integer[])array1))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testAppend() {
        Object[] array0 = new Integer[]{};
        Assertions.assertThat((Object[])array0).hasSize(0);
        Object[] array1 = (Integer[])MoreArrays.append((Object[])array0, (Object)0);
        Assertions.assertThat((Object[])array1).hasSize(1);
        Assertions.assertThat((Integer)array1[0]).isEqualTo(0);
        Assertions.assertThat((Object[])array0).hasSize(0);
        Object[] array2 = (Integer[])MoreArrays.append((Object[])array1, (Object)1);
        Assertions.assertThat((Object[])array2).hasSize(2);
        Assertions.assertThat((Integer)array2[0]).isEqualTo(0);
        Assertions.assertThat((Integer)array2[1]).isEqualTo(1);
    }

    @Test
    void testAdd() {
        Object[] array0 = new Integer[]{};
        Assertions.assertThat((Object[])array0).hasSize(0);
        Object[] array1 = (Integer[])MoreArrays.add((Object[])array0, (int)0, (Object)0);
        Assertions.assertThat((Object[])array1).hasSize(1);
        Assertions.assertThat((Object[])array1).containsExactly((Object[])new Integer[]{0});
        Assertions.assertThat((Object[])array0).hasSize(0);
        Object[] array2 = (Integer[])MoreArrays.add((Object[])array1, (int)0, (Object)1);
        Assertions.assertThat((Object[])array2).hasSize(2);
        Assertions.assertThat((Object[])array2).containsExactly((Object[])new Integer[]{1, 0});
        Object[] array3 = (Integer[])MoreArrays.add((Object[])array2, (int)2, (Object)2);
        Assertions.assertThat((Object[])array3).hasSize(3);
        Assertions.assertThat((Object[])array3).containsExactly((Object[])new Integer[]{1, 0, 2});
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> MoreArraysTest.lambda$testAdd$4((Integer[])array3))).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testAddAllBytes() {
        byte[] array1 = new byte[]{6, 5, 4, 3, 2, 1};
        byte[] array2 = new byte[]{1, 2, 3};
        byte[] expected = new byte[]{6, 5, 4, 3, 2, 1, 1, 2, 3};
        byte[] joinedArray = MoreArrays.addAll((byte[])array1, (byte[])array2);
        Assertions.assertThat((byte[])joinedArray).isEqualTo((Object)expected);
    }

    @Test
    void testRemove() {
        Object[] array0 = new Integer[]{0, 1, 2, 3, 4};
        Assertions.assertThat((Object[])array0).hasSize(5);
        Object[] array1 = (Integer[])MoreArrays.remove((Object[])array0, (int)0);
        Assertions.assertThat((Object[])array1).hasSize(4);
        Assertions.assertThat((Object[])array1).containsExactly((Object[])new Integer[]{1, 2, 3, 4});
        Assertions.assertThat((Object[])array0).hasSize(5);
        Object[] array2 = (Integer[])MoreArrays.remove((Object[])array1, (int)2);
        Assertions.assertThat((Object[])array2).hasSize(3);
        Assertions.assertThat((Object[])array2).containsExactly((Object[])new Integer[]{1, 2, 4});
        Object[] array3 = (Integer[])MoreArrays.remove((Object[])array2, (int)2);
        Assertions.assertThat((Object[])array3).hasSize(2);
        Assertions.assertThat((Object[])array3).containsExactly((Object[])new Integer[]{1, 2});
        Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> MoreArraysTest.lambda$testRemove$5((Integer[])array3))).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testContains() {
        Object[] array0 = new Integer[]{0, 1, 2, 3, 4};
        Assertions.assertThat((boolean)MoreArrays.contains((Object[])array0, (Object)0)).isTrue();
        Assertions.assertThat((boolean)MoreArrays.contains((Object[])array0, (Object)2)).isTrue();
        Assertions.assertThat((boolean)MoreArrays.contains((Object[])array0, (Object)4)).isTrue();
        Assertions.assertThat((boolean)MoreArrays.contains((Object[])array0, (Object)10)).isFalse();
    }

    @Test
    void testIndexOf() {
        Object[] array0 = new Integer[]{0, 1, 2, 2, 0, 1};
        Assertions.assertThat((int)MoreArrays.indexOf((Object[])array0, (Object)0)).isEqualTo(0);
        Assertions.assertThat((int)MoreArrays.indexOf((Object[])array0, (Object)1)).isEqualTo(1);
        Assertions.assertThat((int)MoreArrays.indexOf((Object[])array0, (Object)2)).isEqualTo(2);
        Assertions.assertThat((int)MoreArrays.indexOf((Object[])array0, (Object)10)).isEqualTo(-1);
    }

    @Test
    void testLastIndexOf() {
        Object[] array0 = new Integer[]{0, 1, 2, 2, 0, 1};
        Assertions.assertThat((int)MoreArrays.lastIndexOf((Object[])array0, (Object)0)).isEqualTo(4);
        Assertions.assertThat((int)MoreArrays.lastIndexOf((Object[])array0, (Object)1)).isEqualTo(5);
        Assertions.assertThat((int)MoreArrays.lastIndexOf((Object[])array0, (Object)2)).isEqualTo(3);
        Assertions.assertThat((int)MoreArrays.lastIndexOf((Object[])array0, (Object)10)).isEqualTo(-1);
    }

    @Test
    void testBytesToPrimitive() {
        Byte[] boxedArray = new Byte[]{(byte)0, (byte)1, (byte)2, (byte)3, (byte)4};
        byte[] primitiveArray = new byte[]{0, 1, 2, 3, 4};
        Assertions.assertThat((byte[])primitiveArray).isEqualTo((Object)MoreArrays.toPrimitive((Byte[])boxedArray));
    }

    @Test
    void testBytesToObject() {
        Object[] boxedArray = new Byte[]{(byte)0, (byte)1, (byte)2, (byte)3, (byte)4};
        byte[] primitiveArray = new byte[]{0, 1, 2, 3, 4};
        Assertions.assertThat((Object[])boxedArray).isEqualTo((Object)MoreArrays.toObject((byte[])primitiveArray));
    }

    private static /* synthetic */ void lambda$testRemove$5(Integer[] array3) throws Throwable {
        MoreArrays.remove((Object[])array3, (int)10);
    }

    private static /* synthetic */ void lambda$testAdd$4(Integer[] array3) throws Throwable {
        MoreArrays.add((Object[])array3, (int)10, (Object)10);
    }

    private static /* synthetic */ void lambda$testResize$3(Integer[] array1) throws Throwable {
        MoreArrays.resize((Object[])array1, (int)2);
    }
}

