/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.collect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.atlanmod.commons.AbstractTest;
import org.atlanmod.commons.collect.MoreIterables;
import org.junit.jupiter.api.Test;

@ParametersAreNonnullByDefault
class MoreIterablesTest
extends AbstractTest {
    MoreIterablesTest() {
    }

    @Test
    void testConstructor() throws Exception {
        Constructor constructor = MoreIterables.class.getDeclaredConstructor(new Class[0]);
        Assertions.assertThat((boolean)Modifier.isPrivate(constructor.getModifiers())).isTrue();
        constructor.setAccessible(true);
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> constructor.newInstance(new Object[0]))).isInstanceOf(InvocationTargetException.class)).hasCauseExactlyInstanceOf(IllegalStateException.class);
    }

    @Test
    void testIsEmptyWithIterator() {
        Iterable iterable0 = () -> Collections.emptyList().iterator();
        Assertions.assertThat((boolean)MoreIterables.isEmpty(iterable0)).isTrue();
        Iterable iterable1 = () -> Collections.singletonList(0).iterator();
        Assertions.assertThat((boolean)MoreIterables.isEmpty(iterable1)).isFalse();
        Iterable iterable2 = () -> Arrays.asList(0, 1).iterator();
        Assertions.assertThat((boolean)MoreIterables.isEmpty(iterable2)).isFalse();
    }

    @Test
    void testIsNotEmptyWithIterator() {
        Iterable iterable0 = () -> Collections.emptyList().iterator();
        Assertions.assertThat((boolean)MoreIterables.notEmpty(iterable0)).isFalse();
        Iterable iterable1 = () -> Collections.singletonList(0).iterator();
        Assertions.assertThat((boolean)MoreIterables.notEmpty(iterable1)).isTrue();
        Iterable iterable2 = () -> Arrays.asList(0, 1).iterator();
        Assertions.assertThat((boolean)MoreIterables.notEmpty(iterable2)).isTrue();
    }

    @Test
    void testIsEmptyWithList() {
        List iterable0 = Collections.emptyList();
        Assertions.assertThat((boolean)MoreIterables.isEmpty(iterable0)).isTrue();
        List<Integer> iterable1 = Collections.singletonList(0);
        Assertions.assertThat((boolean)MoreIterables.isEmpty(iterable1)).isFalse();
        List<Integer> iterable2 = Arrays.asList(0, 1);
        Assertions.assertThat((boolean)MoreIterables.isEmpty(iterable2)).isFalse();
    }

    @Test
    void testIsNotEmptyWithList() {
        List iterable0 = Collections.emptyList();
        Assertions.assertThat((boolean)MoreIterables.notEmpty(iterable0)).isFalse();
        List<Integer> iterable1 = Collections.singletonList(0);
        Assertions.assertThat((boolean)MoreIterables.notEmpty(iterable1)).isTrue();
        List<Integer> iterable2 = Arrays.asList(0, 1);
        Assertions.assertThat((boolean)MoreIterables.notEmpty(iterable2)).isTrue();
    }
}

