/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.extension;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.log.Log;
import org.atlanmod.commons.log.Logger;
import org.atlanmod.commons.primitive.Strings;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.opentest4j.TestAbortedException;
import org.opentest4j.TestSkippedException;

@ParametersAreNonnullByDefault
public class LoggingExtension
implements BeforeEachCallback,
TestExecutionExceptionHandler,
AfterEachCallback {
    @Nonnull
    protected static final Logger LOG = Log.forName((String)"test");
    private static final String MSG_RUN = LoggingExtension.formatState("Running");
    private static final String MSG_PASS = LoggingExtension.formatState("PASS");
    private static final String MSG_SKIP = LoggingExtension.formatState("SKIP");
    private static final String MSG_ABORT = LoggingExtension.formatState("ABORT");
    private static final String MSG_FAIL = LoggingExtension.formatState("FAIL");
    private static final String MSG_ERROR = LoggingExtension.formatState("ERROR");
    private boolean hasErrors;

    @Nonnull
    private static String formatState(String state) {
        return String.format("--- %s", state);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.hasErrors = false;
        LOG.info((CharSequence)"");
        this.onRunning(context);
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable e) throws Throwable {
        this.onAnyException(context, e);
        throw e;
    }

    public void afterEach(ExtensionContext context) throws Exception {
        context.getExecutionException().ifPresent(throwable -> this.onAnyException(context, (Throwable)throwable));
        if (!this.hasErrors) {
            this.onPass(context);
        }
        LOG.info((CharSequence)"");
        Runtime.getRuntime().gc();
    }

    private void onAnyException(ExtensionContext context, Throwable e) {
        if (this.hasErrors) {
            return;
        }
        this.hasErrors = true;
        if (e instanceof AssertionError) {
            this.onFail(context, (AssertionError)((Object)e));
        } else if (e instanceof TestSkippedException) {
            this.onSkip(context, (TestSkippedException)e);
        } else if (e instanceof TestAbortedException) {
            this.onAbort(context, (TestAbortedException)e);
        } else {
            this.onError(context, e);
        }
    }

    private void onRunning(ExtensionContext context) {
        String methodName = context.getRequiredTestMethod().getName();
        String displayName = Optional.ofNullable(context.getDisplayName()).filter(n -> !n.startsWith(methodName)).map(n -> " " + n).orElse("");
        LOG.info((CharSequence)"{0}: {1}{2}", new Object[]{MSG_RUN, methodName, displayName});
    }

    private void onPass(ExtensionContext context) {
        LOG.info((CharSequence)"{0}{1}", new Object[]{MSG_PASS, this.additionalDetails(context)});
    }

    private void onFail(ExtensionContext context, AssertionError e) {
        if (Objects.nonNull(((Throwable)((Object)e)).getMessage())) {
            Arrays.stream(((Throwable)((Object)e)).getMessage().split(Strings.LR)).filter(s -> Objects.nonNull(s) && !s.isEmpty()).forEach(arg_0 -> ((Logger)LOG).warn(arg_0));
        }
        LOG.warn((CharSequence)"{0}{1}", new Object[]{MSG_FAIL, this.additionalDetails(context)});
    }

    private void onSkip(ExtensionContext context, TestSkippedException e) {
        if (Objects.nonNull(e.getMessage())) {
            String explanation = e.getMessage();
            LOG.warn((CharSequence)"{0}: {1}", new Object[]{MSG_SKIP, explanation});
        } else {
            LOG.warn((CharSequence)"{0}", new Object[]{MSG_SKIP});
        }
    }

    private void onAbort(ExtensionContext context, TestAbortedException e) {
        if (Objects.nonNull(e.getMessage())) {
            String explanation = e.getMessage().replaceFirst("Assumption failed: ", "");
            LOG.warn((CharSequence)"{0}: {1}", new Object[]{MSG_ABORT, explanation});
        } else {
            LOG.warn((CharSequence)"{0}", new Object[]{MSG_ABORT});
        }
    }

    private void onError(ExtensionContext context, Throwable e) {
        LOG.error(e, (CharSequence)"{0}{1}", new Object[]{MSG_ERROR, this.additionalDetails(context)});
    }

    @Nonnull
    protected String additionalDetails(ExtensionContext context) {
        return "";
    }
}

