/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.extension;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.extension.LoggingExtension;
import org.atlanmod.commons.extension.MemoryUsage;
import org.junit.jupiter.api.extension.ExtensionContext;

@ParametersAreNonnullByDefault
public class LoggingWithMemoryExtension
extends LoggingExtension {
    @Nonnull
    private static final ExtensionContext.Namespace NS = ExtensionContext.Namespace.create((Object[])new Object[]{"atlanmod.logging"});

    @Override
    public void beforeEach(ExtensionContext context) throws Exception {
        super.beforeEach(context);
        context.getStore(NS).put((Object)"memory.usage", (Object)MemoryUsage.now());
    }

    @Override
    @Nonnull
    protected String additionalDetails(ExtensionContext context) {
        MemoryUsage endUsage = MemoryUsage.now();
        MemoryUsage startUsage = (MemoryUsage)context.getStore(NS).remove((Object)"memory.usage", MemoryUsage.class);
        String baseDetails = super.additionalDetails(context);
        return Objects.nonNull(startUsage) ? baseDetails + String.format(" [%s]", MemoryUsage.Diff.between(startUsage, endUsage)) : baseDetails;
    }
}

