/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.hash;

import javax.annotation.ParametersAreNonnullByDefault;
import org.assertj.core.api.Assertions;
import org.atlanmod.commons.AbstractTest;
import org.atlanmod.commons.hash.BinaryHashCode;
import org.atlanmod.commons.hash.HashCode;
import org.atlanmod.commons.primitive.Strings;
import org.junit.jupiter.api.Test;

@ParametersAreNonnullByDefault
class BinaryHashCodeTest
extends AbstractTest {
    private static final HashCode HASH = new BinaryHashCode(Strings.toBytes((String)"HashCode0"));

    BinaryHashCodeTest() {
    }

    @Test
    void testBits() {
        Assertions.assertThat((int)HASH.bits()).isEqualTo(72);
    }

    @Test
    void testToBytes() {
        Assertions.assertThat((byte[])HASH.toBytes()).isEqualTo((Object)Strings.toBytes((String)"HashCode0"));
    }

    @Test
    void testToHexString() {
        Assertions.assertThat((String)HASH.toHexString()).isEqualToIgnoringCase((CharSequence)"48617368436f646530");
    }

    @Test
    void testHashCode() {
        byte[] bytes = HASH.toBytes();
        int hashCode = bytes[0] & 0xFF | (bytes[1] & 0xFF) << 8 | (bytes[2] & 0xFF) << 16 | (bytes[3] & 0xFF) << 24;
        Assertions.assertThat((int)HASH.hashCode()).isEqualTo(hashCode);
        BinaryHashCode littleHash = new BinaryHashCode(Strings.toBytes((String)"HC"));
        Assertions.assertThat((int)littleHash.bits()).isLessThan(32);
        Assertions.assertThat((int)littleHash.hashCode()).isEqualTo(17224);
    }

    @Test
    void testEquals() {
        Assertions.assertThat((boolean)HASH.equals(HASH)).isTrue();
        Assertions.assertThat((boolean)HASH.equals(null)).isFalse();
        Assertions.assertThat((boolean)HASH.equals(new BinaryHashCode(Strings.toBytes((String)"HashCode0")))).isTrue();
        Assertions.assertThat((boolean)HASH.equals(new BinaryHashCode(Strings.toBytes((String)"HC")))).isFalse();
    }
}

