/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.hash;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.atlanmod.commons.AbstractTest;
import org.atlanmod.commons.hash.HashCode;
import org.atlanmod.commons.hash.Hasher;
import org.atlanmod.commons.hash.NativeHasher;
import org.atlanmod.commons.hash.StandardHashers;
import org.junit.jupiter.api.Test;

@ParametersAreNonnullByDefault
class HasherTest
extends AbstractTest {
    private static final String DATA = "Lorem ipsum dolor sit amet, consectetur adipiscing elit volutpat";

    HasherTest() {
    }

    @Nonnull
    private static HashCode hashWith(Hasher hasher, String name) {
        Assertions.assertThat((Object)StandardHashers.forName((String)name)).isSameAs((Object)hasher);
        return hasher.hash(DATA);
    }

    @Test
    void testConstructor() throws Exception {
        Constructor constructor = StandardHashers.class.getDeclaredConstructor(new Class[0]);
        Assertions.assertThat((boolean)Modifier.isPrivate(constructor.getModifiers())).isTrue();
        constructor.setAccessible(true);
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> constructor.newInstance(new Object[0]))).isInstanceOf(InvocationTargetException.class)).hasCauseExactlyInstanceOf(IllegalStateException.class);
    }

    @Test
    void testInvalidAlgorithm() {
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)Assertions.catchThrowable(() -> new NativeHasher("unknown"))).isInstanceOf(RuntimeException.class)).hasCauseExactlyInstanceOf(NoSuchAlgorithmException.class);
    }

    @Test
    void testMD5() {
        Assertions.assertThat((String)HasherTest.hashWith(StandardHashers.MD5, "MD5").toHexString()).isEqualToIgnoringCase((CharSequence)"3ffd50062f0a110bdcfbc7b8d611aa80");
    }

    @Test
    void testSHA1() {
        Assertions.assertThat((String)HasherTest.hashWith(StandardHashers.SHA1, "SHA1").toHexString()).isEqualToIgnoringCase((CharSequence)"469b47430dd9968e127af3034e9b5bd68a700c30");
    }

    @Test
    void testSHA256() {
        Assertions.assertThat((String)HasherTest.hashWith(StandardHashers.SHA256, "SHA256").toHexString()).isEqualToIgnoringCase((CharSequence)"f94d9542e5fe295b1f3209fc2b1e23ff43ddd673350d91612e4ea69233da7a8b");
    }

    @Test
    void testMurmur3() {
        Assertions.assertThat((String)HasherTest.hashWith(StandardHashers.MURMUR3, "MURMUR3").toHexString()).isEqualToIgnoringCase((CharSequence)"14afacf5fbbb494f");
    }

    @Test
    void testXxHash() {
        Assertions.assertThat((String)HasherTest.hashWith(StandardHashers.XX, "XX").toHexString()).isEqualToIgnoringCase((CharSequence)"5ec0f750bc2b69ad");
    }

    @Test
    void testCityHash() {
        Assertions.assertThat((String)HasherTest.hashWith(StandardHashers.CITY, "CITY").toHexString()).isEqualToIgnoringCase((CharSequence)"15dab8ee0877b9a6");
    }

    @Test
    void testFarmHashNA() {
        Assertions.assertThat((String)HasherTest.hashWith(StandardHashers.FARM_NA, "FARM_NA").toHexString()).isEqualToIgnoringCase((CharSequence)"a953e0aba305c7d5");
    }

    @Test
    void testFarmHashUO() {
        Assertions.assertThat((String)HasherTest.hashWith(StandardHashers.FARM_UO, "FARM_UO").toHexString()).isEqualToIgnoringCase((CharSequence)"ea848ff9a62510e3");
    }
}

