/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.hash;

import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import org.assertj.core.api.Assertions;
import org.atlanmod.commons.AbstractTest;
import org.atlanmod.commons.hash.HashCode;
import org.atlanmod.commons.hash.LongHashCode;
import org.atlanmod.commons.primitive.Longs;
import org.junit.jupiter.api.Test;

@ParametersAreNonnullByDefault
class LongHashCodeTest
extends AbstractTest {
    private static final HashCode HASH = new LongHashCode(123456789L);

    LongHashCodeTest() {
    }

    @Test
    void testBits() {
        Assertions.assertThat((int)HASH.bits()).isEqualTo(64);
    }

    @Test
    void testToBytes() {
        Assertions.assertThat((byte[])HASH.toBytes()).isEqualTo((Object)Longs.toBytes((long)123456789L));
    }

    @Test
    void testToHexString() {
        Assertions.assertThat((String)HASH.toHexString()).isEqualToIgnoringCase((CharSequence)"75bcd15");
    }

    @Test
    void testHashCode() {
        Assertions.assertThat((int)HASH.hashCode()).isEqualTo(Objects.hash(123456789));
        LongHashCode littleHash = new LongHashCode(25L);
        Assertions.assertThat((int)littleHash.bits()).isEqualTo(64);
        Assertions.assertThat((int)littleHash.hashCode()).isEqualTo(56);
    }

    @Test
    void testEquals() {
        Assertions.assertThat((boolean)HASH.equals(HASH)).isTrue();
        Assertions.assertThat((boolean)HASH.equals(null)).isFalse();
        Assertions.assertThat((boolean)HASH.equals(new LongHashCode(123456789L))).isTrue();
        Assertions.assertThat((boolean)HASH.equals(new LongHashCode(25L))).isFalse();
    }
}

