/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.io;

import javax.annotation.ParametersAreNonnullByDefault;
import org.assertj.core.api.Assertions;
import org.atlanmod.commons.AbstractTest;
import org.atlanmod.commons.io.MoreFiles;
import org.junit.jupiter.api.Test;

@ParametersAreNonnullByDefault
class MoreFilesTest
extends AbstractTest {
    MoreFilesTest() {
    }

    @Test
    void testFileExtension() {
        Assertions.assertThat((String)MoreFiles.fileExtension((String)".log")).isEqualTo("log");
        Assertions.assertThat((String)MoreFiles.fileExtension((String)"atlanmod.log")).isEqualTo("log");
        Assertions.assertThat((String)MoreFiles.fileExtension((String)"atlanmod..log")).isEqualTo("log");
        Assertions.assertThat((String)MoreFiles.fileExtension((String)".atlanmod.log")).isEqualTo("log");
        Assertions.assertThat((String)MoreFiles.fileExtension((String)"dir/atlanmod.log")).isEqualTo("log");
        Assertions.assertThat((String)MoreFiles.fileExtension((String)"atlanmod.tar.gz")).isEqualTo("gz");
        Assertions.assertThat((String)MoreFiles.fileExtension((String)"/")).isEmpty();
        Assertions.assertThat((String)MoreFiles.fileExtension((String)".")).isEmpty();
        Assertions.assertThat((String)MoreFiles.fileExtension((String)"..")).isEmpty();
        Assertions.assertThat((String)MoreFiles.fileExtension((String)"...")).isEmpty();
        Assertions.assertThat((String)MoreFiles.fileExtension((String)"atlanmod")).isEmpty();
        Assertions.assertThat((String)MoreFiles.fileExtension((String)"atlanmod.")).isEmpty();
        Assertions.assertThat((String)MoreFiles.fileExtension((String)".atlanmod.")).isEmpty();
        Assertions.assertThat((String)MoreFiles.fileExtension((String)"parent.dir/atlanmod")).isEmpty();
        Assertions.assertThat((String)MoreFiles.fileExtension((String)"parent/.dir/atlanmod")).isEmpty();
    }

    @Test
    void testNameWithoutExtension() {
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)".log")).isEmpty();
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)"atlanmod.log")).isEqualTo("atlanmod");
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)"atlanmod..log")).isEqualTo("atlanmod.");
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)".atlanmod.log")).isEqualTo(".atlanmod");
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)"dir/atlanmod.log")).isEqualTo("atlanmod");
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)"atlanmod.tar.gz")).isEqualTo("atlanmod.tar");
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)"/")).isEmpty();
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)".")).isEmpty();
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)"..")).isEqualTo(".");
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)"...")).isEqualTo("..");
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)"atlanmod")).isEqualTo("atlanmod");
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)"atlanmod.")).isEqualTo("atlanmod");
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)".atlanmod.")).isEqualTo(".atlanmod");
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)"parent.dir/atlanmod")).isEqualTo("atlanmod");
        Assertions.assertThat((String)MoreFiles.nameWithoutExtension((String)"parent/.dir/atlanmod")).isEqualTo("atlanmod");
    }
}

