/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.io.serializer;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.assertj.core.api.Assertions;
import org.atlanmod.commons.io.serializer.AbstractSerializerTest;
import org.atlanmod.commons.io.serializer.BinarySerializer;
import org.atlanmod.commons.io.serializer.BinarySerializerFactory;
import org.junit.jupiter.api.Test;

@ParametersAreNonnullByDefault
class BinarySerializerTest
extends AbstractSerializerTest {
    BinarySerializerTest() {
    }

    @Test
    void testSerializeDeserializeObject() throws IOException {
        BinarySerializer serializer = BinarySerializerFactory.getInstance().forAny();
        List<Integer> object = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
        List<Integer> result = this.process(object, serializer);
        Assertions.assertThat(result).containsExactly((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
    }

    @Test
    void testSerializeDeserializeObjectWithStream() throws IOException {
        BinarySerializer serializer = BinarySerializerFactory.getInstance().forAny();
        List<Integer> object = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
        List<Integer> result = this.process(object, serializer);
        Assertions.assertThat(result).containsExactly((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
    }
}

