/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.primitive;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.assertj.core.api.Assertions;
import org.atlanmod.commons.AbstractTest;
import org.atlanmod.commons.primitive.Booleans;
import org.atlanmod.commons.primitive.Bytes;
import org.atlanmod.commons.primitive.Strings;
import org.junit.jupiter.api.Test;

@ParametersAreNonnullByDefault
class BytesTest
extends AbstractTest {
    BytesTest() {
    }

    @Test
    void testToBoolean() {
        boolean actual0 = Bytes.toBoolean((byte[])Booleans.toBytes((Boolean)Boolean.TRUE));
        Assertions.assertThat((boolean)actual0).isTrue();
        boolean actual1 = Bytes.toBoolean((byte[])Booleans.toBytes((Boolean)Boolean.FALSE));
        Assertions.assertThat((boolean)actual1).isFalse();
    }

    @Test
    void testToShort() {
        int expected0 = 28433;
        byte[] bytes = ByteBuffer.allocate(2).putShort((short)28433).array();
        short actual0 = Bytes.toShort((byte[])bytes);
        Assertions.assertThat((short)actual0).isEqualTo((short)28433);
    }

    @Test
    void testToChar() {
        int expected0 = 78;
        byte[] bytes = ByteBuffer.allocate(2).putChar('N').array();
        char actual0 = Bytes.toChar((byte[])bytes);
        Assertions.assertThat((char)actual0).isEqualTo('N');
    }

    @Test
    void testToInt() {
        int expected0 = 1654125381;
        byte[] bytes = ByteBuffer.allocate(4).putInt(1654125381).array();
        int actual0 = Bytes.toInt((byte[])bytes);
        Assertions.assertThat((int)actual0).isEqualTo(1654125381);
    }

    @Test
    void testToLong() {
        long long0 = 1354566516474223156L;
        byte[] bytes = ByteBuffer.allocate(8).putLong(1354566516474223156L).array();
        long actual0 = Bytes.toLong((byte[])bytes);
        Assertions.assertThat((long)actual0).isEqualTo(1354566516474223156L);
    }

    @Test
    void testToFloat() {
        float expected0 = 1.3989543E29f;
        byte[] bytes = ByteBuffer.allocate(4).putFloat(1.3989543E29f).array();
        float actual0 = Bytes.toFloat((byte[])bytes);
        Assertions.assertThat((float)actual0).isEqualTo(1.3989543E29f);
    }

    @Test
    void testToDouble() {
        double expected0 = 1.9876412089108105E203;
        byte[] bytes = ByteBuffer.allocate(8).putDouble(1.9876412089108105E203).array();
        double actual0 = Bytes.toDouble((byte[])bytes);
        Assertions.assertThat((double)actual0).isEqualTo(1.9876412089108105E203);
    }

    @Test
    void testToString() {
        String expected0 = "AtlanmodIsAwesome!";
        byte[] bytes = "AtlanmodIsAwesome!".getBytes();
        String actual0 = Bytes.toString((byte[])bytes);
        Assertions.assertThat((String)actual0).isEqualTo("AtlanmodIsAwesome!");
    }

    @Test
    void testToStringBinaryAndReverse() {
        String expected0 = "AtlanmodIsAwesome!";
        byte[] bytes = Strings.toBytes((String)expected0);
        String actual0 = Bytes.toStringBinary((byte[])bytes);
        Assertions.assertThat((String)actual0).isEqualTo("41746c616e6d6f644973417765736f6d6521");
        byte[] actualBytes0 = Strings.toBytesBinary((String)actual0);
        Assertions.assertThat((byte[])actualBytes0).contains(bytes);
        Assertions.assertThat((String)Bytes.toString((byte[])actualBytes0)).isEqualTo(expected0);
    }

    @Test
    void testAsList() {
        byte[] bytes = new byte[]{1, 2, 3, 4, 5};
        List actual = Bytes.asList((byte[])bytes);
        Assertions.assertThat((int)actual.size()).isEqualTo(bytes.length);
        ArrayList<Byte> expected = new ArrayList<Byte>(bytes.length);
        for (byte each : bytes) {
            expected.add(each);
        }
        Assertions.assertThat((List)actual).isEqualTo(expected);
    }

    @Test
    void testAsListEmpty() {
        List actual = Bytes.asList((byte[])new byte[0]);
        Assertions.assertThat((List)actual).isEmpty();
    }

    @Test
    void testToArray() {
        byte[] expected = new byte[]{1, 2, 3, 4, 5};
        ArrayList<Byte> expectedAsList = new ArrayList<Byte>();
        for (byte each : expected) {
            expectedAsList.add(each);
        }
        Assertions.assertThat((int)expectedAsList.size()).isEqualTo(expected.length);
        byte[] actual = Bytes.toArray(expectedAsList);
        Assertions.assertThat((int)actual.length).isEqualTo(expected.length);
        Assertions.assertThat((byte[])actual).isEqualTo((Object)expected);
    }

    @Test
    void testToArrayEmpty() {
        byte[] actual = Bytes.toArray(Collections.emptyList());
        Assertions.assertThat((byte[])actual).isEmpty();
    }
}

